/*
 * Created on 2004-2-25
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.ds.bpm.enums.activitydef.service.ServiceDefEnums;
import com.ds.config.BPDPlugin;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.ServiceParams;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.enums.EnumsUtil;

/**
 * <p>
 * Title: ISD设计工具（BPD）
 * </p>
 * <p>
 * Description:命令控制
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author 文章 2018-1-5 14:13:32
 * @version 3.0
 */
public class ActivityService extends ExpressionElement {

    private XMLAttribute canReSend = new XMLAttribute(EnumsUtil.getAttribute(ServiceDefEnums.CanReSend));

    private XMLAttribute timeoutOperation = new XMLAttribute(EnumsUtil.getAttribute(ServiceDefEnums.TimeoutOperation));

    private XMLAttribute method = new XMLAttribute(EnumsUtil.getAttribute(ServiceDefEnums.Method));

    private XMLAttribute requestType = new XMLAttribute(EnumsUtil.getAttribute(ServiceDefEnums.RequestType));

    private XMLAttribute responseType = new XMLAttribute(EnumsUtil.getAttribute(ServiceDefEnums.ResponseType));

    ServiceParams serviceParams = new ServiceParams(ServiceDefEnums.HttpParams);

    private XMLAttribute timeOut = new XMLAttribute(ServiceDefEnums.TimeOut.getName(), ServiceDefEnums.TimeOut.getDisplayName());

    private XMLAttribute timeOutTryTimes = new XMLAttribute(ServiceDefEnums.TimeOutTrytimes.getName(), ServiceDefEnums.TimeOutTrytimes.getDisplayName());

    private XMLAttribute url = new XMLAttribute(ServiceDefEnums.Url.getName(), ServiceDefEnums.Url.getDisplayName());

    Formulas serviceSelected = new Formulas(this, FormulaType.ServiceSelectedID);

    public ActivityService(BPDPlugin plugin) {
	super(plugin);
	fillStructure();
    }

    protected void fillStructure() {
	super.fillStructure();

	complexStructure.add(canReSend);

	complexStructure.add(timeOut);

	complexStructure.add(timeOutTryTimes);

	complexStructure.add(timeoutOperation);

	complexStructure.add(serviceParams);
	complexStructure.add(method);
	complexStructure.add(url);
	complexStructure.add(responseType);
	complexStructure.add(requestType);
	complexStructure.add(serviceSelected);

    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
	NodeList nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
	Element easElem;
	Document doc = parent.getOwnerDocument();
	if (nodeList.getLength() != 0) {
	    easElem = (Element) nodeList.item(0);
	} else {
	    easElem = doc.createElement("ExtendedAttributes");
	    parent.appendChild(easElem);
	}
	for (Iterator iter = complexStructure.iterator(); iter.hasNext();) {
	    XMLElement element = (XMLElement) iter.next();
	    if (element instanceof Formulas) {
		element.toXML(easElem);
	    } else {
		Element eaElem = doc.createElement("ExtendedAttribute");
		eaElem.setAttribute("Name", element.toName());
		eaElem.setAttribute("Value", element.toValue().toString());
		easElem.appendChild(eaElem);
	    }
	}
    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
	Object obj = getProperty("Activity");
	if (obj == null) {
	    throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
	}
	act = (Activity) obj;
	ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
	Set easToRemove = new HashSet();
	Iterator it = exAttrs.toCollection().iterator();
	String nm = "";
	String val = "";
	List performerSelectedList = new ArrayList();
	List readerSelectedList = new ArrayList();
	List insteadSignSelectedList = new ArrayList();
	while (it.hasNext()) {
	    ExtendedAttribute ea = (ExtendedAttribute) it.next();
	    nm = ea.get("Name").toValue().toString();
	    val = ea.get("Value").toValue().toString();
	    if (nm.startsWith("DeviceSelectedID".toUpperCase())) {
		performerSelectedList.add(ea);
		easToRemove.add(ea);
		continue;
	    }

	    if (nm.equalsIgnoreCase("CanReSend")) {
		canReSend.setValue(val);
		canReSend.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }
	    if (nm.equalsIgnoreCase("TimeoutOperation")) {
		timeoutOperation.setValue(val);
		timeoutOperation.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }
	    if (nm.equalsIgnoreCase("method")) {
		method.setValue(val);
		method.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }

	    if (nm.equalsIgnoreCase("timeOut")) {
		timeOut.setValue(val);
		timeOut.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }
	    if (nm.equalsIgnoreCase("timeOutTryTimes")) {
		timeOutTryTimes.setValue(val);
		timeOutTryTimes.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }

	    if (nm.equalsIgnoreCase("requestType")) {
		requestType.setValue(val);
		requestType.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }
	    if (nm.equalsIgnoreCase("responseType")) {
		responseType.setValue(val);
		responseType.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }
	    if (nm.equalsIgnoreCase("ServiceParams")) {
		serviceParams.setValue(val);
		continue;
	    }

	    if (nm.equalsIgnoreCase("Url")) {
		url.setValue(val);

		continue;
	    }

	}
	serviceSelected.afterImporting(performerSelectedList);

	exAttrs.toCollection().removeAll(easToRemove);
    }

    public void setLabelName() {
	// 初始化页面显示属性
	setLabelName(this.getBpdElement().getDisplayname());

    }

    public Object clone() {
	ActivityService ar = (ActivityService) super.clone();
	ar.serviceSelected = (Formulas) this.serviceSelected.clone();
	ar.timeoutOperation = (XMLAttribute) this.timeoutOperation.clone();
	
	
	ar.timeOut = (XMLAttribute) this.timeOut.clone();
	ar.timeOutTryTimes = (XMLAttribute) this.timeOutTryTimes.clone();

	ar.canReSend = (XMLAttribute) this.canReSend.clone();
	ar.serviceParams = (ServiceParams) this.serviceParams.clone();
	ar.method = (XMLAttribute) this.method.clone();
	ar.requestType = (XMLAttribute) this.requestType.clone();
	ar.url = (XMLAttribute) this.url.clone();
	ar.responseType = (XMLAttribute) this.responseType.clone();
	ar.fillStructure();
	ar.fillStructure();
	return ar;
    }

    public XMLPanel getPanel() {

	XMLPanel performerPanel = serviceSelected.getPanel();

	XMLPanel timoutPanel = new XMLGroupPanel(this, new XMLElement[] { canReSend, timeoutOperation,this.timeOut,this.timeOutTryTimes},"高级属性");

	XMLPanel urlPanel = new XMLGroupPanel(this, new XMLElement[] {  url, method, requestType, responseType, serviceParams }, "自定义调用");

	return new XMLTabbedPanel(this, new XMLPanel[] {performerPanel , urlPanel, timoutPanel});
    }
}
