
package com.ds.bpm.bpd.plugin.impl.activity;

import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.plugin.impl.process.Forms;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.enums.form.FormNameEnum;
import com.ds.config.BPDPlugin;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.*;

public class ActivityFormPlugin extends ExpressionElement {

    private Forms forms;



    public ActivityFormPlugin(BPDPlugin plugin) {
        super(plugin);
        setLabelName(plugin.getDisplayname()==null ? "动态表单":plugin.getDisplayname());
        forms = new Forms(this);
        fillStructure();
    }

    public WorkflowProcess getProcess() {
        return wp;
    }

    protected void fillStructure() {
        super.fillStructure();
    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
        NodeList nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
        Element easElem;
        Document doc = parent.getOwnerDocument();
        if (nodeList.getLength() != 0) {
            easElem = (Element) nodeList.item(0);
        } else {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }

        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            if (element instanceof Formulas) {
                element.toXML(easElem);
            } else {
                Element eaElem = doc.createElement("ExtendedAttribute");
                eaElem.setAttribute("Name", element.toName());
                eaElem.setAttribute("Value", element.toValue().toString());
                eaElem.setAttribute("Type", FormulaType.ESDCOM.getBaseType().getType());
                easElem.appendChild(eaElem);
            }
        }

    }


    public XMLAttribute getXMLAttributeByName(String name) {

        Iterator it = complexStructure.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof XMLAttribute) {
                XMLAttribute att = (XMLAttribute) obj;
                if (name.equalsIgnoreCase(att.toKey().toString())) {
                    return att;
                }
            }
        }

        return null;

    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
        Object obj = getProperty("Activity");
        if (obj == null) {
            throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
        }
        act = (Activity) obj;
        ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";
        List wpForms = new ArrayList();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();
            val = ea.get("Value").toValue().toString();


        if (nm.startsWith(FormNameEnum.FORM.getType())) {
            easToRemove.add(ea);
            if (!nm.equalsIgnoreCase(FormNameEnum.FORM.getType())) {
                wpForms.add(ea);
            }
        }
        }

        exAttrs.toCollection().removeAll(easToRemove);

        ((Forms) forms).afterImporting(wpForms);
    }

    public void setLabelName() {
        // 初始化页面显示属性
        setLabelName(this.getBpdElement().getDisplayname());
    }

    public Object clone() {
        ActivityFormPlugin ar = (ActivityFormPlugin) super.clone();
        ar.forms = this.forms.clone();
        ar.fillStructure();
        return ar;
    }

    public XMLPanel getPanel() {

        return new XMLTabbedPanel(this, new XMLPanel[]{forms.getPanel()});
    }
}
