/*
 * Created on 2004-2-25
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.ds.config.BPDPlugin;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ds.bpm.bpd.enums.ActivityCommandEnums;
import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.CommandListeners;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.enums.activitydef.deivce.ActivityDefDeviceAtt;
import com.ds.enums.EnumsUtil;

/**
 * <p>
 * Title: ISD设计工具（BPD）
 * </p>
 * <p>
 * Description:命令控制
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author 文章 2018-1-5 14:13:32
 * @version 3.0
 */
public class ActivityCommand extends ExpressionElement {

    private XMLAttribute commandTimeOut = new XMLAttribute(ActivityCommandEnums.CommandTimeOut.getName(), ActivityCommandEnums.CommandTimeOut.getDisplayName());

    private XMLAttribute commandDelayTime = new XMLAttribute(ActivityCommandEnums.CommandDelayTime.getType(), ActivityCommandEnums.CommandDelayTime.getDisplayName());

    private XMLAttribute reRryTimes = new XMLAttribute(ActivityCommandEnums.CommandRetryTimes.getName(), ActivityCommandEnums.CommandRetryTimes.getDisplayName());

    private CommandListeners listeners = new CommandListeners(this);

    private XMLAttribute commandExecType = new XMLAttribute(EnumsUtil.getAttribute(ActivityCommandEnums.CommandExecType));

    private XMLAttribute reTryType = new XMLAttribute(EnumsUtil.getAttribute(ActivityCommandEnums.CommandReTryType));

    private XMLAttribute canOffLineSend = new XMLAttribute(EnumsUtil.getAttribute(ActivityCommandEnums.CanOffLineSend));

    private Formulas commandSelected = new Formulas(this, FormulaType.CommandSelectedID);

    // min=0
    private ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(this);

    public ActivityCommand(BPDPlugin plugin) {
	super(plugin);
	fillStructure();
    }

    public WorkflowProcess getProcess() {
	return wp;
    }

    protected void fillStructure() {
	super.fillStructure();
	commandDelayTime.setValue(0);
	commandTimeOut.setValue(60);
	reRryTimes.setValue(3);
	complexStructure.add(commandTimeOut);
	complexStructure.add(commandExecType);
	complexStructure.add(reTryType);
	complexStructure.add(commandSelected);
	complexStructure.add(canOffLineSend);
	complexStructure.add(refExtendedAttributes);
	complexStructure.add(commandDelayTime);
	complexStructure.add(reRryTimes);

	// }
	ExtendedAttribute ea;
	// 把监听器属性加到扩展属性
	ea = new ExtendedAttribute(refExtendedAttributes);
	ea.get("Value").setRequired(false);
	ea.set("Name", "CommandListeners");
	ea.setAnyXMLCollection(listeners);

	((ArrayList) refExtendedAttributes.toCollection()).add(ea);

    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
	NodeList nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
	Element easElem;
	Document doc = parent.getOwnerDocument();
	if (nodeList.getLength() != 0) {
	    easElem = (Element) nodeList.item(0);
	} else {
	    easElem = doc.createElement("ExtendedAttributes");
	    parent.appendChild(easElem);
	}

	for (Iterator iter = complexStructure.iterator(); iter.hasNext();) {
	    XMLElement element = (XMLElement) iter.next();
	    if (element instanceof Formulas) {
		element.toXML(easElem);
	    } else {
		Element eaElem = doc.createElement("ExtendedAttribute");
		eaElem.setAttribute("Name", element.toName());
		eaElem.setAttribute("Type", FormulaType.CommandSelectedID.getBaseType().getType());
		eaElem.setAttribute("Value", element.toValue().toString());
		easElem.appendChild(eaElem);
	    }
	}
	commandSelected.toXML(easElem);
	listeners.toXML(easElem);
    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
	Object obj = getProperty("Activity");
	if (obj != null) {
		act = (Activity) obj;
		ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
		Set easToRemove = new HashSet();
		Iterator it = exAttrs.toCollection().iterator();
		String nm = "";
		String val = "";
		List commandSelectedList = new ArrayList();

		while (it.hasNext()) {
		    ExtendedAttribute ea = (ExtendedAttribute) it.next();
		    nm = ea.get("Name").toValue().toString();
		    val = ea.get("Value").toValue().toString();
		    String type = ea.get("Type").toValue().toString();

		    if (type != null && type.equals(FormulaType.CommandSelectedID.getBaseType().getType())) {
			
			if (nm.startsWith(ActivityDefDeviceAtt.COMMANDSELECTEDID.getType())) {
			    commandSelectedList.add(ea);
			    easToRemove.add(ea);
			    continue;
			}

			if (nm.equalsIgnoreCase(ActivityCommandEnums.CommandExecType.getType())) {
			    commandExecType.setValue(val);

			    commandExecType.refreshDisplayValue();
			    easToRemove.add(ea);
			    continue;
			}
			if (nm.equalsIgnoreCase(ActivityCommandEnums.CommandReTryType.getType())) {
			    reTryType.setValue(val);
			    reTryType.refreshDisplayValue();
			    easToRemove.add(ea);
			    continue;
			}
			if (nm.equalsIgnoreCase(ActivityCommandEnums.CanOffLineSend.getType())) {
			    canOffLineSend.setValue(val);
			    canOffLineSend.refreshDisplayValue();
			    easToRemove.add(ea);
			    continue;
			}

			if (nm.equalsIgnoreCase(ActivityCommandEnums.CommandDelayTime.getType())) {
			    commandDelayTime.setValue(val);
			    commandDelayTime.refreshDisplayValue();
			    easToRemove.add(ea);
			    continue;
			}

			if (nm.equalsIgnoreCase(ActivityCommandEnums.CommandTimeOut.getType())) {
			    commandTimeOut.setValue(val);
			    commandTimeOut.refreshDisplayValue();
			    easToRemove.add(ea);
			    continue;
			}
			if (nm.equalsIgnoreCase(ActivityCommandEnums.CommandRetryTimes.getType())) {
			    reRryTimes.setValue(val);
			    reRryTimes.refreshDisplayValue();
			    easToRemove.add(ea);
			    continue;
			}
		    }

		}
		listeners.afterImporting();
		commandSelected.afterImporting(commandSelectedList);
		exAttrs.toCollection().removeAll(easToRemove);
	   // throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
	}
	
    }

    public void setLabelName() {
	// 初始化页面显示属性
	setLabelName(Message.getLanguageDependentString("Activity.Command.display"));

    }

    public Object clone() {
	ActivityCommand ar = (ActivityCommand) super.clone();
	ar.commandExecType = (XMLAttribute) this.commandExecType.clone();
	ar.reTryType = (XMLAttribute) this.reTryType.clone();
	ar.canOffLineSend = (XMLAttribute) this.canOffLineSend.clone();
	ar.commandSelected = (Formulas) this.commandSelected.clone();
	ar.commandDelayTime = (XMLAttribute) this.commandDelayTime.clone();
	ar.reRryTimes = (XMLAttribute) this.reRryTimes.clone();
	ar.commandTimeOut = (XMLAttribute) this.commandTimeOut.clone();
	ar.listeners = (CommandListeners) this.listeners.clone();
	ar.fillStructure();
	return ar;
    }

    public XMLPanel getPanel() {
	XMLPanel commonPanel = new XMLGroupPanel(this, new XMLElement[] {  commandTimeOut, reRryTimes, commandDelayTime,commandExecType,canOffLineSend,reTryType }, Message.getLanguageDependentString("Activity.Command.Common.display"));
	return new XMLTabbedPanel(this, new XMLPanel[] { commonPanel, commandSelected.getPanel(), listeners.getPanel() });
    }
}
