/*
 * Created on 2004-2-15
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin;

import com.ds.bpm.bpd.config.AppConfigManager;
import com.ds.common.util.ClassUtility;
import com.ds.config.ActivityDefImpl;
import com.ds.config.BPDPlugin;
import com.ds.config.BPDProjectConfig;
import com.ds.config.PluginType;
import com.ds.enums.ServiceStatus;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 插件管理工具类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 *
 * @author Huchm 2004-2-15 10:30:26
 * @version 1.0
 */
public class PluginManager {

    // 插件文件名称
    public static final String appFileName = "application_config.xml";

    private static Map map = new HashMap();

    // 应用名称
    private String appName;

    private BPDProjectConfig classification;

    private PluginManager(String appName, String classificationName) {
        this.appName = appName;
        classification = AppConfigManager.getInstance().getApplicationMap().get(appName).getBPDProjectConfigMap().get(classificationName);
    }

    public static PluginManager getInstance(String appName, String classification) {
        PluginManager manager;
        if (map.get(appName + classification) != null) {
            manager = (PluginManager) map.get(appName + classification);
        } else {
            manager = new PluginManager(appName, classification);
            map.put(appName + classification, manager);
        }
        return manager;
    }

    // 得到所有插件集合
    public Map getPlugins() {
        Map map = new HashMap();
        List<BPDPlugin> plugins = classification.getBpdElementsList();
        for (BPDPlugin bpdElem : plugins) {
            String impl = bpdElem.getImplementation();
            String name = bpdElem.getName();
            try {
                Object obj = ClassUtility.loadClass(impl).newInstance();
                map.put(name, (PluginElement) obj);
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return new HashMap(map);
    }


    // 得到某种类型的插件集
    public Map getPlugins(PluginType type, ActivityDefImpl impltype) throws PluginException {
        Map map = new HashMap();
        if (classification != null) {
            List<BPDPlugin> plugins = classification.getBpdElementsList();
            for (BPDPlugin bpdElem : plugins) {
                String impl = bpdElem.getImplementation();
                String name = bpdElem.getName();
                PluginType pluginType = bpdElem.getPluginType();
                if (pluginType != null && pluginType.equals(type) && bpdElem.getStatus().equals(ServiceStatus.normal)) {
                    if (impltype == null || bpdElem.getActivityType().equals(impltype)) {
                        try {

                            Object obj = ClassUtility.loadClass(impl).getConstructor(new Class[]{BPDPlugin.class}).newInstance(bpdElem);
                            map.put(name, (PluginElement) obj);
                        } catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }


        }

        return map;
    }

    public BPDPlugin getBPDElement(String name) {
        return this.classification.getElementByName(name);
    }

    // 得到指定名称插件的参数集
    public Map getPluginParams(String name) {
        return getBPDElement(name).getParameters();
    }

    public String getAppName() {
        return appName;
    }
}
