/*
 * Created on 2004-2-16
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 插件异常类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-2-16 20:44:05
 * @version 1.0
 */
public class PluginException extends Exception {

	/** Exception that might have caused this one. */
	private Throwable cause;

	/** Exception code that defined in Plugin. */
	private int errorCode;

	/**
	 * Constructs a build exception with no descriptive information.
	 */
	public PluginException() {
		super();
	}

	/**
	 * Constructs an exception with the given descriptive message and error
	 * code.
	 * 
	 * @param message
	 *            A description of or information about the exception. Should
	 *            not be <code>null</code>.
	 * @param errorCode
	 *            Error code defined in Plugin.
	 */
	public PluginException(String message, int errorCode) {
		super(message);
		this.errorCode = errorCode;
	}

	/**
	 * Constructs an exception with the given descriptive message and error
	 * code.
	 * 
	 * @param message
	 *            A description of or information about the exception. Should
	 *            not be <code>null</code>.
	 * @param cause
	 *            The exception that might have caused this one. May be
	 *            <code>null</code>.
	 * @param errorCode
	 *            Error code defined in Plugin.
	 */
	public PluginException(String message, Throwable cause, int errorCode) {
		this(message, cause);
		this.errorCode = errorCode;
	}

	/**
	 * Constructs an exception with the given descriptive message.
	 * 
	 * @param message
	 *            A description of or information about the exception. Should
	 *            not be <code>null</code>.
	 */
	public PluginException(String message) {
		super(message);
	}

	/**
	 * Constructs an exception with the given message and exception as a root
	 * cause.
	 * 
	 * @param message
	 *            A description of or information about the exception. Should
	 *            not be <code>null</code> unless a cause is specified.
	 * @param cause
	 *            The exception that might have caused this one. May be
	 *            <code>null</code>.
	 */
	public PluginException(String message, Throwable cause) {
		super(message);
		this.cause = cause;
	}

	/**
	 * Constructs an exception with the given exception as a root cause.
	 * 
	 * @param cause
	 *            The exception that might have caused this one. Should not be
	 *            <code>null</code>.
	 */
	public PluginException(Throwable cause) {
		super(cause.toString());
		this.cause = cause;
	}

	/**
	 * Retrieves the BPM exception code for this <code>PluginException</code>
	 * object.
	 * 
	 * @return the vendor's error code
	 */
	public int getErrorCode() {
		return errorCode;
	}

	/**
	 * Returns the nested exception, if any.
	 * 
	 * @return the nested exception, or <code>null</code> if no exception is
	 *         associated with this one
	 */
	public Throwable getCause() {
		return cause;
	}

	/**
	 * Returns the nested exception, if any.
	 * 
	 * @return the nested exception, or <code>null</code> if no exception is
	 *         associated with this one
	 */
	public Throwable getException() {
		return cause;
	}

	/**
	 * Returns the location of the error and the error message.
	 * 
	 * @return the location of the error and the error message
	 */
	public String toString() {
		return getMessage();
	}

	/**
	 * Prints the stack trace for this exception and any nested exception to
	 * <code>System.err</code>.
	 */
	public void printStackTrace() {
		printStackTrace(System.err);
	}

	/**
	 * Prints the stack trace of this exception and any nested exception to the
	 * specified PrintStream.
	 * 
	 * @param ps
	 *            The PrintStream to print the stack trace to. Must not be
	 *            <code>null</code>.
	 */
	public void printStackTrace(PrintStream ps) {
		synchronized (ps) {
			if (errorCode != 0) {
				ps.println("Error Code: " + errorCode);
			}
			super.printStackTrace(ps);
			if (cause != null) {
				ps.println("--- Nested Exception ---");
				cause.printStackTrace(ps);
			}
		}
	}

	/**
	 * Prints the stack trace of this exception and any nested exception to the
	 * specified PrintWriter.
	 * 
	 * @param pw
	 *            The PrintWriter to print the stack trace to. Must not be
	 *            <code>null</code>.
	 */
	public void printStackTrace(PrintWriter pw) {
		synchronized (pw) {
			if (errorCode != 0) {
				pw.println("Error Code: " + errorCode);
			}
			super.printStackTrace(pw);
			if (cause != null) {
				pw.println("--- Nested Exception ---");
				cause.printStackTrace(pw);
			}
		}
	}
}
