package com.ds.bpm.bpd.misc.task;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.common.JDSException;
import com.ds.common.swing.progress.Task;
import com.ds.common.swing.util.SwingWorker;

public class CreateVersionTask extends Task {

    private String versionId;

    public CreateVersionTask(String versionId) {
        setLengthOfTask(10);
        this.versionId = versionId;
    }

    /*
     * 创建流程新版本
     *
     * @see com.ds.common.swing.progress.Task#go()
     */
    public void go() {
        final SwingWorker worker = new SwingWorker() {
            public Object construct() {

                try {
                    setMessage(ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.GetProcessInfo.Name.display"));
                    // 从WebService服务器获得工作流信息集

                    String xpdlString = BPD.getInstance().getBPDService().getProcessDefListFromDB(versionId);
                    setMessage(ResourceManager.getLanguageDependentString("RemoteProcessOpen.Progress.Message.CreateVersion.Name.display"));
                    BPD.getInstance().cloneWorkflowProcess(xpdlString);
                } catch (JDSException e) {
                    BPD.getInstance().getBPDService().handleWebServiceException(e);
                    stop();
                    // e.printStackTrace();
                    return new Object();
                } finally {
                    stop();
                }
                return new Object();
            }
        };
        worker.start();
    }

    /*
     * @see com.ds.common.swing.progress.Task#cancel()
     */
    public void cancel() {
    }

    /*
     * @see com.ds.common.swing.progress.Task#complete()
     */
    public void complete() {
    }
}