/* Version.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：从配置文件读软件版本的构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 *  CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.misc;

import java.io.InputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

import com.ds.bpm.bpd.BPDConstants;

/**
 * Reads the Version from the file version.properies
 */
public class Version {

	private static ResourceBundle versionResource;

	private static String version = "";

	static {
		try {
			String vp = BPDConstants.RESOURCE_FILEPATH + "version.properties";
			InputStream is = Version.class.getClassLoader()
					.getResourceAsStream(vp);
			if (is != null) {
				versionResource = new PropertyResourceBundle(is);
				String stat = versionResource.getString("version.status");
				// System.out.println(stat);
				if (stat.equals("")) {
					version = versionResource.getString("version.number.major")
							+ "."
							+ versionResource.getString("version.number.minor")
							+ " (build "
							+ versionResource.getString("version.build") + ")";
					// + versionResource.getString("version.date")+ ")";
				} else {
					version = versionResource.getString("version.number.major")
							+ "."
							+ versionResource.getString("version.number.minor")
							+ "-" + stat + " (build "
							+ versionResource.getString("version.build") + ")";
				}
			}
		} catch (java.io.IOException e) {
			System.err.println(e.getMessage());
			version = "{File version.properties not available.}";
		}
	}

	/**
	 * Returns the current version number
	 */
	public static String getVersion() {
		return version;
	}

}
