package com.ds.bpm.bpd.misc;

import com.ds.common.database.metadata.ColInfo;
import com.ds.common.database.metadata.TableInfo;
import com.ds.iot.Area;
import com.ds.iot.Place;

import javax.swing.tree.TreeNode;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableTree {

    private TreeNode root;


    public TableTree(List<TableInfo> tableInfos) {
        Map<String, OrgTreeNode> map = new HashMap<String, OrgTreeNode>();
        root = new OrgTreeNode();

        for (TableInfo tableInfo : tableInfos) {
            map.put(tableInfo.getName(), new OrgTreeNode(tableInfo));
        }

        for (TableInfo tableInfo : tableInfos) {
            if (tableInfo != null) {
                OrgTreeNode node = (OrgTreeNode) map.get(tableInfo.getName());
                if (node.getParent() == null) {
                    insertNodeInto(node, (OrgTreeNode) root);
                }
                List<ColInfo> colInfos = tableInfo.getColList();
                for (ColInfo colInfo : colInfos) {
                    insertNodeInto(new OrgTreeNode(colInfo), (OrgTreeNode) map.get(tableInfo.getName()));
                }

            }

        }

    }

    /**
     * @param parent
     * @param index
     * @return
     */
    public TreeNode getChild(TreeNode parent, int index) {
        return ((TreeNode) parent).getChildAt(index);
    }

    public Enumeration getChildren(TreeNode parent) {
        return parent.children();
    }

    public int getChildCount(TreeNode parent) {
        return parent.getChildCount();
    }

    public boolean isLeaf(TreeNode node) {
        return node.isLeaf();
    }

    public void insertNodeInto(OrgTreeNode newChild, OrgTreeNode parent, int index) {
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }

        parent.insert(newChild, index);
    }

    public void insertNodeInto(OrgTreeNode newChild, OrgTreeNode parent) {
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }

        parent.insert(newChild);
    }

    public void removeNodeFromParent(OrgTreeNode node) {
        OrgTreeNode parent = (OrgTreeNode) node.getParent();
        if (parent == null)
            throw new IllegalArgumentException("node does not have a parent.");

        parent.remove(node);
    }

    public TreeNode getRoot() {
        return root;
    }

    /**
     * @param root The root to set.
     */
    public void setRoot(TreeNode root) {
        this.root = root;
    }

}
