/* ShowHideButtonsPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.misc;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.JOptionPane;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.WorkflowManager;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.elements.Participant;
import com.ds.bpm.bpd.xml.elements.Participants;
import com.ds.bpm.bpd.xml.panels.XMLControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLTableControlPanel;

public class ShowHideButtonsPanel extends XMLControlPanel {
	private WorkflowManager workflowManager;

	public ShowHideButtonsPanel(Participants myOwner, WorkflowManager wm,
			boolean isVertical) {

		super(myOwner, "", isVertical, false);

		this.workflowManager = wm;

		String s = XMLUtil.getLanguageDependentString("ShowKey");
		String h = XMLUtil.getLanguageDependentString("HideKey");

		Dimension dim = getPreferredDimension(new String[] { s, h });

		XMLButton buttonShow = new XMLButton(s, "Show", dim);
		XMLButton buttonHide = new XMLButton(h, "Hide", dim);

		buttonShow.setEnabled(!myOwner.isReadOnly());
		buttonHide.setEnabled(!myOwner.isReadOnly());

		if (isVertical) {
			add(Box.createVerticalGlue());
		} else {
			add(Box.createHorizontalGlue());
		}
		add(buttonShow);
		if (isVertical) {
			add(Box.createRigidArea(new Dimension(0, 5)));
		} else {
			add(Box.createRigidArea(new Dimension(5, 0)));
		}
		add(buttonHide);
		if (isVertical) {
			add(Box.createVerticalGlue());
		} else {
			add(Box.createHorizontalGlue());
			add(Box.createRigidArea(new Dimension(0, 15)));
		}

		buttonShow.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				Participants pOwner = (Participants) getOwner();
				XMLTableControlPanel tcp = (XMLTableControlPanel) pOwner
						.getControlPanel();
				Participant selectedParticipant = (Participant) tcp
						.getSelectedElement();
				if (selectedParticipant != null) {
					Participants pps = (Participants) pOwner.getPackage().get(
							"Participants");
					if ((!pOwner.isMine(selectedParticipant) && pOwner
							.getCollectionElement(selectedParticipant.getID()) != null)
							|| (pOwner.isExternal(selectedParticipant) && pps
									.getCollectionElement(selectedParticipant
											.getID()) != null)) {
						BPD
								.getInstance()
								.message(
										ResourceManager
												.getLanguageDependentString("WarningCannotShowRedefinedParticipant"),
										JOptionPane.WARNING_MESSAGE);
					} else {
						workflowManager.showNode(selectedParticipant);
					}
				}
			}
		});

		buttonHide.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				Participants pOwner = (Participants) getOwner();
				XMLTableControlPanel tcp = (XMLTableControlPanel) pOwner
						.getControlPanel();
				Participant selectedParticipant = (Participant) tcp
						.getSelectedElement();
				if (selectedParticipant != null) {
					workflowManager.hideNode(selectedParticipant);
				}
			}
		});

	}

}
