package com.ds.bpm.bpd.misc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.org.Org;
import com.ds.org.OrgNotFoundException;
import com.ds.org.Person;
import com.ds.org.conf.OrgConstants;
import com.ds.server.OrgManagerFactory;

public class PersonExtTree {
    protected static Log log = LogFactory.getLog(OrgConstants.CONFIG_KEY.getType(), PersonExtTree.class);
    private List persons = new ArrayList();
    private Org[] orgs;
    private Org topOrg;
    private String topOrgId;
    private boolean viewPerson = true;

    public PersonExtTree(List persons, String topOrgId, boolean viewPerson) {
	Map orgMap = new HashMap();
	this.viewPerson = viewPerson;
	if (topOrgId == null) {
	    this.topOrgId = OrgManagerFactory.getOrgManager().getTopOrgs().get(0).getOrgId();

	} else {
	    this.topOrgId = topOrgId;
	}

	for (int i = 0; i < persons.size(); i++) {
	    Person perosn = (Person) persons.get(i);

	    Org[] orgs = (Org[]) perosn.getOrgList().toArray();
	    if (orgs != null) {
		for (int j = 0; j < orgs.length; j++) {
		    if (!orgMap.containsKey(orgs[j].getOrgId())) {
			addOrg(orgMap, orgs[j]);
		    }
		}
	    }
	}
	this.orgs = (Org[]) orgMap.values().toArray(new Org[0]);

	this.persons = persons;
    }

    public String getChildTree(String orgId) {
	if (orgId == null || orgId.equals(ExtTree.TOPID)) {
	    return this.getTopTree();
	}

	Org org = null;
	try {
	    if (orgId.startsWith("org")) {
		orgId = orgId.substring(3, orgId.length());
	    }
	    org = OrgManagerFactory.getOrgManager().getOrgByID(orgId);
	} catch (OrgNotFoundException e) {
	    e.printStackTrace();
	}
	ExtNode childNode = new ExtNode();
	if (org == null || !isOrgInOrgs(org, orgs)) {

	    childNode.setId(org.getOrgId());
	    childNode.setText("读取错误");
	    childNode.setCnName("读取错误");
	    childNode.setUid("orgerr");
	    childNode.setLeaf("true");
	} else {
	    childNode.setId(org.getOrgId());
	    childNode.setText(org.getName());
	    childNode.setCnName(org.getName());
	    childNode.setUid(org.getOrgId());

	    if (this.viewPerson) {

		addPersonItem(childNode, org);
	    }

	    if (childNode.getChildren().size() > 0) {
		childNode.setLeaf("true");
	    } else {
		childNode.setLeaf("false");
	    }
	    if (org.getChildrenList().size() > 0) {
		List<Org> list = org.getChildrenList();
		

		CommonComparator comparator = new CommonComparator();
		comparator.setFields_user(new String[] { "index" });
		Collections.sort(list, comparator);

		for (int j = 0; j < list.size(); j++) {
		    Org ccorg = list.get(j);
		    if (isOrgInOrgs(ccorg, orgs)) {
			addChildNode(childNode, ccorg, orgs);
		    }
		}
	    }

	}

	ExtTree tree = new ExtTree();
	tree.setNode(childNode);
	StringBuffer layoutJson = new StringBuffer();
	tree.serializChild(layoutJson);
	return layoutJson.toString();
    }

    private String getTopTree() {
	String rootStr = "点击选择组织机构";
	ExtNode root = new ExtNode();
	root.setId(topOrg.getOrgId());
	root.setLeaf("false");
	root.setText(topOrg.getName());
	root.setCnName(topOrg.getName());
	root.setUid(topOrg.getOrgId());
	if (orgs.length == 0) {
	    rootStr = "没有设定阅办人";
	    root.setText(rootStr);
	    root.setCnName(rootStr);
	    root.setLeaf("true");
	} else {
	    List<Org> list = new ArrayList<Org>();
	    for (int k = 0; k < this.topOrg.getChildrenList().size(); k++) {
		list.add(topOrg.getChildrenList().get(k));
	    }

	    CommonComparator comparator = new CommonComparator();
	    comparator.setFields_user(new String[] { "index" });
	    Collections.sort(list, comparator);
	    for (int k = 0; k < list.size(); k++) {
		addChildNode(root, list.get(k), orgs);
	    }
	}
	ExtTree tree = new ExtTree();
	tree.setNode(root);
	StringBuffer layoutJson = new StringBuffer();
	tree.serializChild(layoutJson);
	return layoutJson.toString();
    }

    /**
     * @param map
     * @param getOrgId
     */
    private void addOrg(Map map, Org org) {
	if (org != null) {
	    map.put(org.getOrgId(), org);
	    Org parent = org.getParent();

	    if (parent != null) {
		if (this.topOrgId != null && org.getOrgId().equals(topOrgId)) {
		    this.topOrg = parent;
		    map.put(parent.getOrgId(), parent);
		} else {
		    if (!map.containsKey(parent.getOrgId())) {
			addOrg(map, parent);
		    }
		}

	    } else {
		this.topOrg = org;

	    }

	}

    }

    private boolean isOrgInOrgs(Org org, Org[] orgs) {
	for (int i = 0; i < orgs.length; i++) {
	    if (org.getOrgId().equals(orgs[i].getOrgId())) {
		return Boolean.TRUE;
	    }
	}
	return false;
    }

    protected void addPersonItem(ExtNode parentnode, Org org) {
	CommonComparator comparator = new CommonComparator();
	comparator.setFields_user(new String[] { "index" });
	Collections.sort(this.persons, comparator);

	for (int i = 0; this.persons.size() > i; i++) {
	    Person person = (Person) persons.get(i);

	    if (!person.getAccount().equals("yanpinga") && !person.getAccount().equals("yanpingb") && !person.getAccount().equals("yanpingc")) {
		if (this.isPersonInOrg(org, person.getID())) {
		    ExtNode inputNode = new ExtNode();
		    inputNode.setId(person.getID());
		    inputNode.setText(person.getName());
		    inputNode.setCnName(org.getName());
		    inputNode.setUid(person.getID());

		    inputNode.setLeaf("true");
		    parentnode.addChild(inputNode);
		    inputNode.setParent(parentnode);
		}
		;
	    }
	}

    }

    private boolean isPersonInOrg(Org org, String personId) {
	List<Person> persons = org.getPersonList();
	for (Person person:persons) {
	    if (personId.equalsIgnoreCase(person.getID())) {
		return Boolean.TRUE;
	    }
	}
	return false;
    }

    private ExtNode addChildNode(ExtNode parentnode, Org org, Org[] orgs) {
	if (isOrgInOrgs(org, orgs)) {
	    ExtNode inputNode = new ExtNode();
	    inputNode.setId("org" + org.getOrgId());
	    inputNode.setText(org.getName());
	    inputNode.setCnName(org.getName());
	    inputNode.setUid(org.getOrgId());

	    inputNode.setLeaf("false");
	    parentnode.addChild(inputNode);
	    inputNode.setParent(parentnode);
	    if (this.viewPerson) {

		addPersonItem(inputNode, org);
	    }

	    // if (org.getChildren().length>0){
	    // Org[] ccorgs=org.getChildren();
	    // for (int j=0;j<ccorgs.length;j++){
	    // Org ccorg=ccorgs[j];
	    // if (isOrgInOrgs(ccorg,orgs)){
	    // addChildNode(inputNode,ccorg,orgs);
	    // }
	    // }
	    // }

	}

	return parentnode;

    }

    class CommonComparator implements Comparator {
	/***
	 * @param 比较对象的属性用String[]的形式传过来
	 *            比较的对象一定要符合javaBean，即要有Set,Get方法
	 */
	String[] fields_user = null;

	public String[] getFields_user() {
	    return fields_user;
	}

	public void setFields_user(String[] fields_user) {
	    this.fields_user = fields_user;
	}

	/**
	 * 定义排序规则 如果按照不止一个属性进行排序 这按照属性的顺序进行排序,类是sql order by 即只要比较出同位置的属性就停止
	 */
	public int compare(Object obj1, Object obj2) {
	    // 没有属性，则不排序
	    if (fields_user == null || fields_user.length <= 0) {
		return 2;// 不比较
	    }
	    for (int i = 0; i < fields_user.length; i++) {
		if (compareField(obj1, obj2, fields_user[i])) {
		    // 如果obj1的属性值大于obj2的属性值，则返回正数
		    return 1;
		} else {
		    // 小于返回负数
		    return -1;
		}
	    }
	    // 相等返回0
	    return 0;
	}

	/**
	 * @param fieldName
	 *            根据属性名排序
	 */
	private boolean compareField(Object o1, Object o2, String fieldName) {
	    try {
		String value1 = getFieldValueByName(fieldName, o1).toString();
		String value2 = getFieldValueByName(fieldName, o2).toString();

		if (Integer.parseInt(value1) > Integer.parseInt(value2)) {
		    return true;
		}
	    } catch (Exception e) {
		log.info("---------对象的该属性不存在或者不允许在此安全级别上反射该属性，详情请查阅JAVA DOC--------");
		e.printStackTrace();
	    }
	    return false;
	}

	/**
	 * @param fieldName
	 *            属性名 obj 对象 反射获得该属性的值
	 */
	private Object getFieldValueByName(String fieldName, Object obj) {
	    try {
		String Letter = fieldName.substring(0, 1).toUpperCase();
		String methodStr = "get" + Letter + fieldName.substring(1);
		Method method = obj.getClass().getMethod(methodStr, new Class[] {});

		Object value = method.invoke(obj, new Object[] {});
		return value;
	    } catch (Exception e) {
		log.info("---------该" + fieldName + "属性不存在----------------------");
		return null;
	    }
	}
    }

}
