package com.ds.bpm.bpd.misc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ds.org.Org;
import com.ds.org.OrgNotFoundException;
import com.ds.org.Person;
import com.ds.server.OrgManagerFactory;

public class OrgExtTree {

    private HashMap orgMap;
    private Integer tier = 0;
    private Org topOrg;
    private String topOrgId;

    public OrgExtTree(String orgId, Integer tier) {

	if (tier != null && tier > 0) {
	    this.tier = tier;
	}
	this.orgMap = new HashMap();
	Org org = null;
	try {
	    org = OrgManagerFactory.getOrgManager().getOrgByID(orgId);
	} catch (OrgNotFoundException e) {
	    e.printStackTrace();
	}
	addOrg(orgMap, org);
    }

    private boolean isOrgInOrgs(Org org, Org[] orgs) {
	for (int i = 0; i < orgs.length; i++) {
	    if (org.getOrgId().equals(orgs[i].getOrgId())) {
		return Boolean.TRUE;
	    }
	}
	return false;
    }

    /**
     * @param map
     * @param person
     */
    private void addOrg(Map map, Org org) {
	if (org != null) {
	    map.put(org.getOrgId(), org);
	    Org parent = org.getParent();

	    if (parent != null) {
		if (this.topOrgId != null && parent.getOrgId().equals(topOrgId)) {
		    this.topOrg = org;

		}
		if (!map.containsKey(parent.getOrgId())) {
		    addOrg(map, parent);
		}
	    } else {
		this.topOrg = org;
	    }

	}

    }

    public String getChildTree(String orgId) {

	if (orgId == null) {
	    return this.getTopTree();
	}

	Org org = null;
	try {
	    org = OrgManagerFactory.getOrgManager().getOrgByID(orgId);
	} catch (OrgNotFoundException e) {
	    // e.printStackTrace();
	    return this.getTopTree();
	}
	ExtNode childNode = new ExtNode();
	if (org == null) {

	    childNode.setId(org.getOrgId());
	    childNode.setText("读取错误");
	    childNode.setCnName("读取错误");
	    childNode.setUid("orgerr");
	    childNode.setLeaf("true");
	} else {
	    childNode.setId(org.getOrgId());
	    childNode.setText(org.getName());
	    childNode.setCnName(org.getName());
	    childNode.setUid(org.getOrgId());

	    addPersonItem(childNode, org);
	    if (org.getChildrenList().size() > 0) {
		childNode.setLeaf("true");
	    } else {
		childNode.setLeaf("false");
	    }

	    for (int k = 0; k < org.getChildrenList().size(); k++) {
		addChildNode(childNode, org.getChildrenList().get(0));
	    }

	}

	ExtTree tree = new ExtTree();
	tree.setNode(childNode);
	StringBuffer layoutJson = new StringBuffer();
	tree.serializChild(layoutJson);
	return layoutJson.toString();
    }

    private String getTopTree() {
	String rootStr = "点击选择组织机构";
	ExtNode root = new ExtNode();
	root.setId("root");
	root.setLeaf("false");
	root.setText(rootStr);
	root.setCnName(rootStr);
	root.setUid("root");
	Org[] orgs = (Org[]) orgMap.values().toArray(new Org[0]);
	if (orgs.length == 0) {
	    rootStr = "没有设定阅办人";
	    root.setText(rootStr);
	    root.setCnName(rootStr);
	    root.setLeaf("true");
	} else {

	    for (int i = 0; i < orgs.length; i++) {
		Org org = orgs[i];
		if (org != null) {
		    if (org.getTier() == this.tier) {
			addChildNode(root, org);
		    }

		}
	    }
	}

	ExtTree tree = new ExtTree();
	tree.setNode(root);
	StringBuffer layoutJson = new StringBuffer();
	tree.serializ(layoutJson);
	return layoutJson.toString();
    }

    protected void addPersonItem(ExtNode parentnode, Org org) {
	List persons = org.getPersonList();
	for (int i = 0; persons.size() > i; i++) {
	    Person person = (Person) persons.get(i);
	    ExtNode inputNode = new ExtNode();
	    inputNode.setId(person.getID());
	    inputNode.setText(person.getName());
	    inputNode.setCnName(org.getName());
	    inputNode.setUid(person.getID());
	    inputNode.setLeaf("true");
	    parentnode.addChild(inputNode);
	    inputNode.setParent(parentnode);

	}

    }

    private boolean isPersonInOrg(Org org, String personId) {
	List<Person> personList = org.getPersonList();
	for (Person person : personList) {
	    if (personId.equalsIgnoreCase(person.getID())) {
		return Boolean.TRUE;
	    }
	}
	return false;
    }

    private ExtNode addChildNode(ExtNode parentnode, Org org) {
	ExtNode inputNode = new ExtNode();
	inputNode.setId(org.getOrgId());
	inputNode.setText(org.getName());
	inputNode.setCnName(org.getName());
	inputNode.setUid(org.getOrgId());
	parentnode.addChild(inputNode);
	inputNode.setParent(parentnode);
	inputNode.setLeaf("false");
	addPersonItem(inputNode, org);

	return parentnode;

    }

}
