package com.ds.bpm.bpd.misc;



import java.util.ArrayList;
import java.util.List;






public class ExtNode

    {
	   
        private String text;
        private String leaf;
        private String id;
        private String uid;
        private String cnName = "";
        private List<ExtNode> children = new ArrayList<ExtNode>();
        private ExtNode parent;
      

		public void serializ(StringBuffer layoutJson)
        {
            layoutJson.append("{");
            layoutJson.append("\"text\":\"").append(filter(text)).append("\",");
            layoutJson.append("\"id\":\"").append(id).append("\",");
           
            if(children.size() > 0)
            {
                layoutJson.append("\"children\":[");
                for(int i = 0;i < children.size();i++)
                {
                    children.get(i).serializ(layoutJson);
                }
                layoutJson.deleteCharAt(layoutJson.length() - 1);
                layoutJson.append("],");
            }
            layoutJson.append("\"uid\":\"").append(uid).append("\",");
           
            layoutJson.append("\"cnName\":\"").append(filter(cnName)).append("\",");        
         
            if (leaf.equals("true") && !id.equals("root")){
                layoutJson.append("\"checked\":").append("false,");
            }
            
            
        
            layoutJson.append("\"leaf\":").append(leaf);
            
            layoutJson.append("},");
        }


		public void serializChild(StringBuffer layoutJson)
        {
          
            if(children.size() > 0)
            {
              
                for(int i = 0;i < children.size();i++)
                {
                    children.get(i).serializ(layoutJson);
                }
              
               
            }
          
        }


		
		
        @Override
        public boolean equals(Object obj)
        {
            return super.equals(obj) || this.getId().equals(((ExtNode)obj).getId());
        }

        @Override
        public int hashCode()
        {
            return Integer.parseInt(Integer.toString(id.toLowerCase().charAt(0)) + id.substring(1));

        }

        public void addChild(ExtNode child)
        {
            children.add(child);
        }

        public boolean containChild(ExtNode child)
        {
//            for(int k=0;children.size()>0;k++){
//            	ExtNode node=children.get(k);
//            	if (node.getId().equals(child.getId())){
//            		return true;
//            	}
//            }
        	
        	return children.contains(child);
        }

        private String filter(String str)
        {
            if(str == null)
            {
                return "";
            }
            str = str.replaceAll("(?i)<br>","");
            return str;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getLeaf() {
            return leaf;
        }

        public void setLeaf(String leaf) {
            this.leaf = leaf;
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<ExtNode> getChildren() {
            return children;
        }

        public void setChildren(List<ExtNode> children) {
            this.children = children;
        }

        public ExtNode getParent() {
            return parent;
        }

        public void setParent(ExtNode parent) {
            this.parent = parent;
        }

        public String getUid() {
            return uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

    

        public String getCnName() {
            return cnName;
        }

        public void setCnName(String cnName) {
            this.cnName = cnName;
        }

      
    }
