/* ExternalParticipants.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.ldap;

import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

// This is not a real WfMC DTD element, but it is introduced to help
public class ExternalParticipants extends XMLComplexElement {
	private XMLAttribute host = new XMLAttribute("Host");

	private XMLAttribute port = new XMLAttribute("Port");

	private XMLAttribute baseDN = new XMLAttribute("BaseDN");

	private XMLAttribute objectClassFilter = new XMLAttribute(
			"ObjectClassFilter", new String[] { "AllListed",
					"organizationalUnit", "organizationalRole", "person",
					"organizationalPerson", "inetOrgPerson", }, 0) {
		// to enable manual enterance of object class
		public XMLPanel getPanel() {
			return new XMLComboPanel(this, null, XMLPanel.BOX_LAYOUT, false,
					true);
		}
	};

	private XMLAttribute searchScope = new XMLAttribute("SearchScope",
			new String[] { "SCOPE_ONE", "SCOPE_SUB" }, 1);

	private Security security = new Security();

	public ExternalParticipants(com.ds.bpm.bpd.xml.elements.Package p) {

		super();

		host.setValue("localhost");
		host.setRequired(true);
		port.setValue("389");
		port.setRequired(true);
		complexStructure.add(host);
		complexStructure.add(port);
		complexStructure.add(baseDN);
		complexStructure.add(objectClassFilter);
		complexStructure.add(searchScope);
		complexStructure.add(security);
	}

}
