/* TransitionRenderer.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.elements.Condition;
import com.ds.bpm.enums.route.RouteCondition;

import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.GraphConstants;

/**
 * Represents a view for a model's Transition object.
 */
public class TransitionRenderer extends EdgeRenderer {

    public TransitionRenderer() {
	super();
    }

    public void paint(Graphics g) {
	Transition tr = (Transition) view.getCell();
	if (tr.hasCondition()) {
	    lineWidth = 3;
	} else {
	    lineWidth = 1;
	}
	Color clr = Utils.getColor(BPDConfig.getInstance().getTransitionColor());
	String ttype = tr.getType();
	if (ttype.equals(RouteCondition.DEFAULTEXCEPTION.getType())) {
	    clr = Utils.getColor(BPDConfig.getInstance().getDefaultExceptionTransitionColor());
	} else if (ttype.equals(RouteCondition.EXCEPTION.getType())) {
	    clr = Utils.getColor(BPDConfig.getInstance().getExceptionTransitionColor());
	} else if (ttype.equals(RouteCondition.DEFAULTEXCEPTION.getType())) {
	    clr = Utils.getColor(BPDConfig.getInstance().getOtherwiseTransitionColor());
	}

	// String condition=tr.getCondition();

	Shape edgeShape = view.getShape();
	// Sideeffect: beginShape, lineShape, endShape
	if (edgeShape != null) {
	    Graphics2D g2 = (Graphics2D) g;
	    int c = BasicStroke.CAP_BUTT;
	    int j = BasicStroke.JOIN_MITER;
	    g2.setStroke(new BasicStroke(lineWidth, c, j));
	    translateGraphics(g);
	    // g.setColor(getForeground());
	    g.setColor(clr);
	    if (view.beginShape != null) {
		if (beginFill)
		    g2.fill(view.beginShape);
		g2.draw(view.beginShape);
	    }
	    if (view.endShape != null) {
		if (endFill)
		    g2.fill(view.endShape);
		g2.draw(view.endShape);
	    }
	    if (lineDash != null) // Dash For Line Only
		g2.setStroke(new BasicStroke(lineWidth, c, j, 10.0f, lineDash, 0.0f));
	    if (view.lineShape != null)
		g2.draw(view.lineShape);

	    if (selected) { // Paint Selected
		g2.setStroke(GraphConstants.SELECTION_STROKE);
		g2.setColor(graph.getHighlightColor());
		if (view.beginShape != null)
		    g2.draw(view.beginShape);
		if (view.lineShape != null)
		    g2.draw(view.lineShape);
		if (view.endShape != null)
		    g2.draw(view.endShape);
	    }
	    if (graph.getEditingCell() != view.getCell()) {
		Object label = graph.convertValueToString(view);
		if (label != null) {
		    g2.setStroke(new BasicStroke(1));
		    g.setFont(getFont());
		    paintLabel(g, label.toString());
		}
	    }
	}
    }
}

/* End of TransitionRenderer.java */
