/* Transition.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.Window;

import com.ds.bpm.bpd.AbstractGraph;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.WorkflowElement;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;

import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultPort;

/**
 * Used to define Transition object in the graph.
 */
public class Transition extends DefaultEdge implements WorkflowElement {

   /**
    * Creates transition.
    */
   public Transition () {
      this(null);
   }

   /**
    * Creates transition with given userObject.
    */
   public Transition (Object userObject) {
      super(userObject);
   }


   /**
    * Returns source activity.
    */
   public Activity getSourceActivity () {
      return (Activity)((DefaultPort)source).getParent();
   }

   /**
    * Returns target activity.
    */
   public Activity getTargetActivity () {
      return (Activity)((DefaultPort)target).getParent();
   }

   /**
    * Shows a dialog for editing transition properties.
    */
   public void showPropertyDialog(Window parentWindow,AbstractGraph graph){
      // if this is not a transition from a start or to the end, show it properties
      if (!(((DefaultPort)source).getParent() instanceof Start) &&
          !(((DefaultPort)target).getParent() instanceof End)) {

         XMLElementDialog xmlED=graph.getProcessEditor().
            getElementEditingDialog();
         if (xmlED.isShowing()) {
            xmlED.switchPanel(getPropertyObject().getPanel(),
                              ResourceManager.getLanguageDependentString("DialogTransitionProperties")+
                                 " - "+userObject.toString(),true);
         } else {
            xmlED.setTitle(ResourceManager.getLanguageDependentString("DialogTransitionProperties")+
                              " - "+userObject.toString());
            xmlED.editXMLElement(getPropertyObject().getPanel(),true,false);
         }
      }
   }

   /**
    * Gets a property object (DTDElement).
    */
   public XMLElement getPropertyObject () {
      return (XMLElement)userObject;
   }

   /**
    * Gets a transition property which name is given in parameter what.
    */
   public XMLElement get (String what) {
      return ((XMLComplexElement)getPropertyObject()).get(what);
   }

   /**
    * Sets a transition property which name is given in parameter what to a
    * value given in a parameter value.
    */
   public void set (String what,Object value) {
      ((XMLComplexElement)getPropertyObject()).set(what,value);
   }

   /**
    * Gets a tooltip text for transition.
    */
   public String getTooltip () {
      if ((getSourceActivity() instanceof Start) ||
             (getTargetActivity() instanceof End)) {

         return null;
      }
      else {
         return ((com.ds.bpm.bpd.xml.elements.Transition)userObject).getTooltip();
      }
   }

   /**
    * Returns an empty string.
    */
   public String toString () {
      return "";
   }

   //HM: enable Transition-copy/paste
   protected Object cloneUserObject() {
      return ((com.ds.bpm.bpd.xml.elements.Transition)userObject).clone();
   }

   public boolean hasCondition () {
	   com.ds.bpm.bpd.xml.elements.Transition tr=
         (com.ds.bpm.bpd.xml.elements.Transition)userObject;
      if (tr==null) return false;
      if (tr.get("Condition").toString().trim().equals("")) {
         return false;
      } else {
         return true;
      }
   }

   public String getType () {
	   com.ds.bpm.bpd.xml.elements.Transition tr=
         (com.ds.bpm.bpd.xml.elements.Transition)userObject;
      if (tr==null) {
         return "";
      } else {
         return ((com.ds.bpm.bpd.xml.elements.Condition)tr.get("Condition")).get("Type").toValue().toString();
      }
   }

   public String getCondition () {
	   com.ds.bpm.bpd.xml.elements.Transition tr=
         (com.ds.bpm.bpd.xml.elements.Transition)userObject;
      if (tr==null) {
         return "";
      } else {
         return ((com.ds.bpm.bpd.xml.elements.Condition)tr.get("Condition")).toString();
      }
   }

}

/* End of Transition.java */
