/* StartRenderer.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：开始活动图形描绘类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;

import javax.swing.ImageIcon;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;

import org.apache.batik.svggen.SVGGraphics2D;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexRenderer;

/**
 * Class used to display start object.
 */
public class StartRenderer extends VertexRenderer {

	private BasicStroke borderStroke = new BasicStroke(2);
	private static final String resurceImage="Pointstart";
	
	//super.setBackground(bckgC);
	/**
	 * Paints Start. Overrides super class paint to add specific painting.
	 */
	protected String getResurceImage(){
		return resurceImage;
	}
	public void paint(Graphics g) {
		Color fillCol = Utils.getColor(BPDConfig.getInstance().getStartColor());
		URL url = ResourceManager.getResource(this.getResurceImage()+ BPDConstants.IMAGE_SUFFIX);		
		ImageIcon imageIcon=new ImageIcon(url);		
		Image image=imageIcon.getImage();
		ImageObserver imageObserver=imageIcon.getImageObserver();
		int b = borderWidth;


		Graphics2D g2 = (Graphics2D) g;
		
		Dimension d = getSize();
		
		boolean tmp = selected;
	
		if (super.isOpaque()) {
			g.setColor(fillCol);
			g.fillOval(b - 1, b - 1, d.width - b, d.height - b);
		}
		g.drawImage(image,b+9 , b+9, d.width -20, d.height -20,imageObserver);
		try {
			setBorder(null);
			setOpaque(false);
			selected = false;
			//super.paint(g);
		} finally {
			selected = tmp;
		}
		
		if (bordercolor != null) {
			g.setColor(bordercolor);
			g2.setStroke(borderStroke);
			g.drawOval(b - 1, b - 1, d.width - b, d.height - b);
		}
		if (selected) {
			g2.setStroke(GraphConstants.SELECTION_STROKE);
			g.setColor(graph.getHighlightColor());
			g.drawOval(b - 1, b - 1, d.width - b, d.height - b);
		}
		
	}
}
