/* ParticipantView.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：画图区域视图类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.VertexView;

/**
 * Represents a view for a model's Participant object.
 */
public class ParticipantView extends VertexView {

	/** Renderer for the class. */
	public static ParticipantRenderer renderer = new ParticipantRenderer();

	/**
	 * Constructs a participant view for the specified model object.
	 * 
	 * @param cell
	 *            reference to the model object
	 */
	public ParticipantView(Object cell, JGraph graph, CellMapper cm) {
		super(cell, graph, cm);
	}

	/**
	 * Returns a renderer for the class.
	 */
	public CellViewRenderer getRenderer() {
		return renderer;
	}

	/**
	 * Returns true if name portion of ParticipantView intersects the given
	 * rectangle.
	 */
	public boolean intersects(Graphics g, Rectangle rect) {
		Rectangle bounds = getBounds().getBounds();
		if (bounds != null) {
			Rectangle nameBounds = new Rectangle((int) bounds.getX(),
					(int) bounds.getY(),
					ParticipantRenderer.participantNameWidth, (int) bounds
							.getHeight());
			return nameBounds.intersects(rect);
		}
		return false;
	}

	/**
	 * Clears childView's and then refreshes it.
	 */
	public void refreshChildViews() {
		childViews.clear();
		refresh(false);
	}

	/**
	 * Returns the bounding rectangle for this view.
	 */
	public Rectangle2D getBounds() {
		return bounds;
	}

	/**
	 * Adds participants child view to it.
	 */
	public void addChildView(CellView childView) {
		if (childView != null) {
			childViews.add(childView);
		}
	}

}

/* End of ParticipantView.java */
