/* Subflow.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：子流程活动图形实现类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.util.Map;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.xml.activity.OutFlow;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;

/*
 * import javax.swing.undo.*; import javax.swing.event.*;
 */

/**
 * Used to define Subflow object in the graph and to modify it's properties.
 */
public class Outflow extends Activity {

	/**
	 * Creates subflow
	 */
	public Outflow() {
		this(null);
	}

	/**
	 * Creates subflow with given userObject.
	 */
	public Outflow(Object userObject) {
		super(userObject);
	}

	/**
	 * Shows referenced process, if no process is referenced, the new process is
	 * created and shown.
	 * 
	 * @param pkg
	 *            The package within the subflow activity is defined.
	 */
	public void showSubflow(com.ds.bpm.bpd.xml.elements.Package pkg) {
		String ID = getProcessID();
		Process pr;
		WorkflowProcess wp = pkg.getWorkflowProcess(ID);
		Map wpMap=BPD.getInstance().getWorkflowProcessMap();
		Map romveMap=BPD.getInstance().getRomveWorkflowProcessMap();
		String versionId=null;
		if (wp==null){		
			wp = BPD.getInstance().getPackageEditor().showProcess(wp, ID);
			versionId=wp.getVersionID();
		}else{
		   versionId=wp.getVersionID();
		if (wpMap.containsKey(versionId)){		
			BPD.getInstance().openWorkflow(versionId,true);	
		}else if(romveMap.containsKey(versionId)){
			BPD.getInstance().openRomveWorkflow(versionId,true);
		}else{
			wp = BPD.getInstance().getPackageEditor().showProcess(wp, ID);
		}
		}
		String mainProcessVersionId=wp.getMainProcess().getVersionID();
		if (wpMap.containsKey(mainProcessVersionId)){
			wpMap.put(versionId,wp);
			BPD.getInstance().getActivedProcessEditor().setProcessFlag(BPDConstants.PROCESS_LOCAL);		
			//BPD.getInstance().openWorkflow(versionId);
			BPD.getInstance().getActivedProcessEditor().valueChanged(null);
		}
		if (romveMap.containsKey(mainProcessVersionId)){
			romveMap.put(versionId,wp);
			BPD.getInstance().getActivedProcessEditor().setProcessFlag(BPDConstants.PROCESS_REMOTE);
			//BPD.getInstance().openRomveWorkflow(versionId);
		}
		//wp = BPD.getInstance().getPackageEditor().showProcess(wp, ID);
		
		getXMLSOutflow().set("WorkflowProcess", wp);
		
	}

	/**
	 * Returns ID of referenced process. If there is no referenced process (the
	 * new process is to be created when editing subflow activity), generates an
	 * ID for new process and returns it.
	 */
	private String getProcessID() {
		OutFlow s = getXMLSOutflow();
		return s.getAttrId();

	}

	/**
	 * Returns a logical (XML) element describing a reference to the process.
	 */
	private OutFlow getXMLSOutflow() {
		return ((com.ds.bpm.bpd.xml.activity.Activity) userObject)
				.getOutflow();
	}

}
