/*
 * @(#)MultiLinedRenderer.java 1.0 12-MAY-2004
 *
 * Copyright (c) 2001-2004, Jenya Burstein All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer. - Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution. - Neither the name of JGraph nor
 * the names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;

import com.ds.bpm.bpd.BPDConfig;

import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

// adjusted for JaWE by Sasa Bojanic
public class MultiLinedRenderer extends JTextArea implements CellViewRenderer {

   /** Cache the current graph for drawing. */
   transient protected JGraph graph;

   /** Cache the current shape for drawing. */
   transient protected VertexView view;

   /** Cached hasFocus and selected value. */
   transient protected boolean hasFocus,
      selected,
      preview,
      opaque;

   /** Cached default foreground and default background. */
   transient protected Color defaultForeground, defaultBackground, bordercolor;

   /** Cached borderwidth. */
   transient protected int borderWidth;

   /** Cached value of the double buffered state */
   transient boolean isDoubleBuffered = false;

   public MultiLinedRenderer () {
      defaultForeground = UIManager.getColor("Tree.textForeground");
      defaultBackground = UIManager.getColor("Tree.textBackground");
      setLineWrap(BPDConfig.getInstance().getNameWrappingStatus());
      setWrapStyleWord(BPDConfig.getInstance().getWrappingStyleWordStatus());
   }

   public Component getRendererComponent(
      JGraph graph,
      CellView view,
      boolean sel,
      boolean focus,
      boolean preview) {

      setLineWrap(BPDConfig.getInstance().getNameWrappingStatus());
      setWrapStyleWord(BPDConfig.getInstance().getWrappingStyleWordStatus());

      this.graph = graph;
      isDoubleBuffered = graph.isDoubleBuffered();
      if (view instanceof VertexView) {
         this.view = (VertexView) view;
         setText(view.getCell().toString());

         if (graph.getEditingCell() != view.getCell()) {
            Object label = graph.convertValueToString(view);
            if (label != null)
               setText(label.toString());
            else
               setText(null);
         } else
            setText(null);
         this.graph = graph;
         this.hasFocus = focus;
         this.selected = sel;
         this.preview = preview;
         Map attributes = view.getAllAttributes();
         installAttributes(graph, attributes);
         return this;
      }
      return null;

   }

   protected void installAttributes(JGraph graph, Map attributes) {
      setOpaque(GraphConstants.isOpaque(attributes));
      Color foreground = GraphConstants.getForeground(attributes);
      setForeground((foreground != null) ? foreground : graph.getForeground());
      Color background = GraphConstants.getBackground(attributes);
      setBackground((background != null) ? background : graph.getBackground());
      Font font = GraphConstants.getFont(attributes);
      setFont((font != null) ? font : graph.getFont());
      Border border= GraphConstants.getBorder(attributes);
      bordercolor = GraphConstants.getBorderColor(attributes);
      if(border != null)
         setBorder(border);
      else if (bordercolor != null) {
         borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth(attributes)));
         setBorder(BorderFactory.createLineBorder(bordercolor, borderWidth));
      }
   }

}

