/* BlockActivityEditor.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：跳转活动图形编辑界面类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.AbstractGraph;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.BPDGraphModel;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;

/**
 * BlockActivityEditor class creates block activity toolbars and menubar as
 * given in property file, and BlockActivityGraph instance which is used to
 * create block activity.
 */
public class BlockActivityEditor extends ProcessEditor {

	public BlockActivityEditor(WorkflowProcess wp, BlockActivity ba,
			AbstractEditor parentEditor) {
		super(wp, parentEditor);
		((BlockActivityGraph) graph).setMyBlockActivity(ba);
	}

	/**
	 * Create an editor to represent the given document.
	 */
	protected AbstractGraph createGraph() {
		BPDGraphModel model = new BPDGraphModel();
		graph = new BlockActivityGraph(model, parentEditor, this);
		return graph;
	}

	/**
	 * Shows a window.
	 */
	/*
	 * public void showWindow (Window parentWindow,String name) {
	 * blockActivityTitle=name; super.showWindow(parentWindow,name); }
	 */

	/**
	 * Gets a title.
	 */
	public String getBlockActivityTitle() {
		String blockActivityTitle = "";
		if (super.getProcessFlag() == null) {
			blockActivityTitle = ResourceManager
					.getLanguageDependentString("NewProcessKey");
		} else {
			if (super.getProcessFlag().equals(BPDConstants.PROCESS_LOCAL)) {
				blockActivityTitle = ResourceManager
						.getLanguageDependentString("LocalProcessKey");
			} else if (super.getProcessFlag().equals(
					BPDConstants.PROCESS_REMOTE)) {
				blockActivityTitle = ResourceManager
						.getLanguageDependentString("RemoteProcessKey");
			}
		}
		blockActivityTitle += ResourceManager
				.getLanguageDependentString("BlockActivityKey")
				+ "-'"
				+ ((BlockActivityGraph) graph).getMyBlockActivity()
						.getPropertyObject().toString() + "'";
		return blockActivityTitle;
	}

	/**
	 * Returns string of toolbars for load.
	 */
	/*
	 * public String toolbarToLoad () { return "blockActivityToolbars"; }
	 */

	/**
	 * Returns string of menubar for load.
	 */
	/*
	 * public String menubarToLoad () { return "blockActivityMenubar"; }
	 */

}

/* End of BlockActivityEditor.java */
