/* Activity.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：活动图形元素构造基类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.Window;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.swing.JFrame;
import javax.swing.JPanel;

import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.AbstractGraph;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.WorkflowElement;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.enums.route.RouteCondition;

public class Activity extends DefaultGraphCell implements WorkflowElement, Linkable {

    // 图形的横坐标
    private int xOff;

    // 图形的纵坐标
    private int yOff;

    protected int activityVisualType = BPDConstants.TYPE_OF_ELEMENT_NORMAL;

    /** Message to display when there are connection errors. */
    protected String connectionErrorMsg = null;

    /**
     * Creates activity.
     */
    public Activity() {
	this(null);
    }

    /**
     * Creates activity with given userObject. Also creates default port for holding activity transitions.
     */
    public Activity(Object userObject) {
	super(userObject);
	// Create Port
	// Floating Center Port (Child 0 is Default)
	DefaultPort port = new DefaultPort("Center");
	add(port);
    }

    public ProcessEditor getImplementationEditor() {
	return null;
    }

    public AbstractEditor getParentEditor() {
	return null;
    }

    /**
     * Gets the port associate with this activity.
     */
    public DefaultPort getPort() {
	for (Enumeration e = children(); e.hasMoreElements();) {
	    Object child = e.nextElement();
	    if (child instanceof DefaultPort) {
		return (DefaultPort) child;
	    }
	}
	return null;
    }

    /**
     * Returns message that represents connection error for this activity, if there is no connection errors, returns
     * <code>null</code>. <BR>
     * NOTE: You must call method getConnectionErrorMessage() right after calling this isWellConnected() method,
     * otherwise you can get wrong results.
     */
    public String getConnectionErrorMessage() {
	return connectionErrorMsg;
    }

    /**
     * Returns <code>true</code> if Activity is a valid source for transition. This depends of activitie's type
     * property, it can accept to be a source for transition if it is a normal or starting.
     */
    public boolean acceptsSource() {
	if (activityVisualType == BPDConstants.TYPE_OF_ELEMENT_NORMAL || activityVisualType == BPDConstants.TYPE_OF_ELEMENT_STARTING) {
	    return true;
	} else {
	    return false;
	}
    }

    /**
     * Returns <code>true</code> if Activity is a valid target for transition. This depends of activitie's type
     * property, it can accept to be a target for for transition if it is a normal or ending.
     */
    public boolean acceptsTarget() {
	if (activityVisualType == BPDConstants.TYPE_OF_ELEMENT_NORMAL || activityVisualType == BPDConstants.TYPE_OF_ELEMENT_ENDING) {
	    return true;
	} else {
	    return false;
	}
    }

    /**
     * Shows a dialog for editing activity properties.
     */
    public void showWebEditor(Window parentWindow, AbstractGraph graph) {
	JFrame frame = new JFrame();
	JPanel editor = BPD.getInstance().getPackageEditor();
	frame.add(editor);
	frame.show();
	// XMLElement xmlED = ((ProcessEditor) graph.getProcessEditor())
	// .getElementEditingDialog();
	//
	// recreatePropertyObjectTransitions();
	// s
	//
	// if (xmlED.isShowing()) {
	// xmlED.switchPanel(getPropertyObject().getPanel(), ResourceManager
	// .getLanguageDependentString("DialogActivityProperties")
	// + " - " + userObject.toString(), true);
	// } else {
	// xmlED.setTitle(ResourceManager
	// .getLanguageDependentString("DialogActivityProperties")
	// + " - " + userObject.toString());
	// xmlED.editXMLElement(getPropertyObject().getPanel(), true, false);
	// }
	//
	// xmlED.setTitle(ResourceManager
	// .getLanguageDependentString("DialogActivityProperties")
	// + " - " + userObject.toString());
	// xmlED.editXMLElement(getPropertyObject().getPanel(), true, false);
    }

    /**
     * Shows a dialog for editing activity properties.
     */
    public void showPropertyDialog(Window parentWindow, AbstractGraph graph) {
	XMLElementDialog xmlED = ((ProcessEditor) graph.getProcessEditor()).getElementEditingDialog();

	recreatePropertyObjectTransitions();

	if (xmlED.isShowing()) {
	    xmlED.switchPanel(getPropertyObject().getPanel(), ResourceManager.getLanguageDependentString("DialogActivityProperties") + " - " + userObject.toString(), true);
	} else {
	    xmlED.setTitle(ResourceManager.getLanguageDependentString("DialogActivityProperties") + " - " + userObject.toString());
	    xmlED.editXMLElement(getPropertyObject().getPanel(), true, false);
	}

	// xmlED.setTitle(ResourceManagerT
	// .getLanguageDependentString("DialogActivityProperties")
	// + " - " + userObject.toString());
	// xmlED.editXMLElement(getPropertyObject().getPanel(), true, false);
    }

    /**
     * Gets a property object (DTDElement).
     */
    public XMLElement getPropertyObject() {
	return (XMLElement) userObject;
    }

    /**
     * Gets an activity property which name is given in parameter what.
     */
    public XMLElement get(String what) {
	// return ((ActivityProperties)userObject).get(what);
	return ((XMLComplexElement) getPropertyObject()).get(what);
    }

    /**
     * Sets value of an activity property which name is given in parameter what to a value given in a parameter value.
     */
    public void set(String what, Object value) {
	((XMLComplexElement) getPropertyObject()).set(what, value);
    }

    /**
     * Gets a tooltip text for activity.
     */
    public String getTooltip() {
	try {
	    return ((com.ds.bpm.bpd.xml.activity.Activity) userObject).getTooltip();
	} catch (Exception e) {
	    return null;
	}
    }

    /**
     * Gets an activity "display name" property.
     */
    public String toString() {
	return userObject.toString();
    }

    /**
     * Create a clone of the cell. The cloning of the user object is deferred to the cloneUserObject() method. NOTE:
     * this original method of DefaultGraphCell is modified to retain synchronization of userObject and value attribute
     * from attribute map when model is attribute store
     * 
     * @return Object a clone of this object.
     */
    public Object clone() {
	Activity c = (Activity) super.clone();
	c.setUserObject(c.userObject);
	return c;
    }

    /**
     * Create a clone of the ActivityProperties object.
     * 
     * @return Object a clone of this activity property object.
     */
    protected Object cloneUserObject() {
	return ((com.ds.bpm.bpd.xml.activity.Activity) userObject).clone();
    }

    public boolean hasAnyPrecondition() {
	Set inL = getIncomingTransitions();
	Iterator it = inL.iterator();
	while (it.hasNext()) {
	    if (((com.ds.bpm.bpd.xml.elements.Transition) ((Transition) it.next()).getPropertyObject()).hasCondition()) {
		return true;
	    }
	}
	return false;
    }

    public boolean hasAnyPostcondition() {
	Set outL = getOutgoingTransitions();
	Iterator it = outL.iterator();
	while (it.hasNext()) {
	    if (((com.ds.bpm.bpd.xml.elements.Transition) ((Transition) it.next()).getPropertyObject()).hasCondition()) {
		return true;
	    }
	}
	return false;
    }

    /**
     * Gets all incoming transitions to this activity (instances of ...graph.Transition class).
     */
    public Set getIncomingTransitions() {
	Set inputTransitions = new HashSet();
	for (Iterator i = getPort().edges(); i.hasNext();) {
	    Transition l = (Transition) i.next();
	    Object target = ((DefaultPort) (l.getTarget())).getParent();
	    if (this == target) {
		inputTransitions.add(l);
	    }
	}
	return inputTransitions;
    }

    /**
     * Gets all outgoing transitions from this activity (instances of ...graph.Transition class).
     */
    public Set getOutgoingTransitions() {
	Set outputTransitions = new HashSet();
	for (Iterator i = getPort().edges(); i.hasNext();) {
	    Transition l = (Transition) i.next();
	    Object source = ((DefaultPort) (l.getSource())).getParent();
	    if (this == source) {
		outputTransitions.add(l);
	    }
	}
	return outputTransitions;
    }

    public void recreatePropertyObjectTransitions() {
	try {
	    com.ds.bpm.bpd.xml.activity.Activity po = (com.ds.bpm.bpd.xml.activity.Activity) userObject;

	    Iterator iter = getOutgoingTransitions().iterator();
	    Set trans = new HashSet();
	    while (iter.hasNext()) {
		Transition tr = (Transition) iter.next();
		com.ds.bpm.bpd.xml.elements.Transition t = (com.ds.bpm.bpd.xml.elements.Transition) tr.getUserObject();
		if (t != null && t.getFrom() != null && t.getTo() != null) {
		    trans.add(t);
		}
	    }
	    po.setOutgoingTransitions(trans);
	} catch (Exception ex) {
	} // Exception is thrown for Start and End activities
    }

    public Set getNonExceptionalOutgoingTransitions() {
	Set outputTransitions = new HashSet();
	for (Iterator i = getPort().edges(); i.hasNext();) {
	    Transition l = (Transition) i.next();
	    Object source = ((DefaultPort) (l.getSource())).getParent();
	    if (this == source) {
		com.ds.bpm.bpd.xml.elements.Transition tuo = (com.ds.bpm.bpd.xml.elements.Transition) l.getPropertyObject();
		com.ds.bpm.bpd.xml.elements.Condition condition = (com.ds.bpm.bpd.xml.elements.Condition) tuo.get("Condition");
		String condType = condition.get("Type").toValue().toString();
		if (!(condType.equals(RouteCondition.EXCEPTION.getType()) || condType.equals(RouteCondition.DEFAULTEXCEPTION.getType()))) {
		    outputTransitions.add(l);
		}
	    }
	}
	return outputTransitions;
    }

    public int getXOff() {
	return xOff;
    }

    public void setXOff(int xOff) {
	this.xOff = xOff;
    }

    public int getYOff() {
	return yOff;
    }

    public void setYOff(int yOff) {
	this.yOff = yOff;
    }
}
