package com.ds.bpm.bpd.enums;

import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Devices;
import com.ds.bpm.bpd.xml.activity.Events;
import com.ds.bpm.bpd.xml.activity.No;
import com.ds.bpm.bpd.xml.activity.OutFlow;
import com.ds.bpm.bpd.xml.activity.Services;
import com.ds.bpm.bpd.xml.activity.SubFlow;
import com.ds.bpm.bpd.xml.activity.Tools;
import com.ds.bpm.bpd.xml.elements.BlockActivity;
import com.ds.config.ActivityDefImpl;

public enum ActivityDefTypeEnums {

    No(ActivityDefImpl.No, 2, No.class),

    Tool(ActivityDefImpl.Tool, 0, Tools.class),

    Device(ActivityDefImpl.Device, 7, Devices.class),

    Service(ActivityDefImpl.Service, 6, Services.class),

    Block(ActivityDefImpl.Block, 4, BlockActivity.class),

    Event(ActivityDefImpl.Event, 8, Events.class),

    SubFlow(ActivityDefImpl.SubFlow, 3, SubFlow.class),

    OutFlow(ActivityDefImpl.OutFlow, 5, OutFlow.class);

    public ActivityDefImpl getDef() {
	return def;
    }

    public void setDef(ActivityDefImpl def) {
	this.def = def;
    }

    public Integer getType() {
	return type;
    }

    public void setType(Integer type) {
	this.type = type;
    }

    private Class<? extends XMLElement> clazz;
    private ActivityDefImpl def;
    private Integer type;

    ActivityDefTypeEnums(ActivityDefImpl def, Integer type, Class<? extends XMLElement> clazz) {

	this.def = def;
	this.type = type;
	this.clazz = clazz;

    }

    public Class<? extends XMLElement> getClazz() {
	return clazz;
    }

    public void setClazz(Class<? extends XMLElement> clazz) {
	this.clazz = clazz;
    }

    public static ActivityDefTypeEnums fromClass(Class<? extends XMLElement> clazz) {
	for (ActivityDefTypeEnums type : ActivityDefTypeEnums.values()) {
	    if (type.getClazz().equals(clazz)) {
		return type;
	    }
	}
	return null;
    }

    public static ActivityDefTypeEnums fromName(String name) {
	for (ActivityDefTypeEnums type : ActivityDefTypeEnums.values()) {
	    if (type.getDef().getType().equals(name)) {
		return type;
	    }
	}
	return null;
    }

}
