/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：配置选项的内容构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.config;

import java.util.ArrayList;

public class ConfigElements {

	private String name;

	private ArrayList members;

	/**
	 * Constructor
	 * 
	 * @param name
	 *            The name of the element of tree
	 */
	public ConfigElements(String name) {
		this.name = name;
		members = new ArrayList();
	}

	public String getName() {
		return name;
	}

	public void addOptionPane(BaseConfigPane pane) {
		if (members.indexOf(pane) != -1)
			return;
		members.add(pane);
	}

	public ArrayList getMembers() {
		return members;
	}

	public Object getMember(int index) {
		return (index >= 0 && index < members.size()) ? members.get(index)
				: null;
	}

	public int getMemberIndex(Object member) {
		return members.indexOf(member);
	}

	public int getMemberCount() {
		return members.size();
	}

	public void save() {
		for (int i = 0; i < members.size(); i++) {
			Object elem = members.get(i);
			try {
				if (elem instanceof BaseConfigPane) {
					((BaseConfigPane) elem).save();
				}
			} catch (Throwable t) {
			}
		}
	}

	public void readConf() {
		for (int i = 0; i < members.size(); i++) {
			Object elem = members.get(i);
			try {
				if (elem instanceof BaseConfigPane) {
					((BaseConfigPane) elem).readConf();
				}
			} catch (Throwable t) {
			}
		}
	}

	public void refreshLanguageDependentStrings() {
		for (int i = 0; i < members.size(); i++) {
			Object elem = members.get(i);
			try {
				if (elem instanceof BaseConfigPane) {
					((BaseConfigPane) elem).refreshLanguageDependentStrings();
				}
			} catch (Throwable t) {
			}
		}
	}

}
