/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：选项配置对话框构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.config;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.MainLeftDownPanel;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;

public class ConfigDialog extends JDialog implements ActionListener,
		TreeSelectionListener {

	private static PackageEditor parent;

	private JTree paneTree;

	private OptionTreeModel treeModel;

	private ConfigElements bpdOptionsRoot;

	private static ConfigDialog optionsDialog;

	private String currPaneName;

	private JPanel cardPanel, configsPanel;

	private JButton okButton, cancelButton, applyButton, restoreDefaultButton;

	public static ConfigDialog getInstance() {
		if (optionsDialog == null) {
			parent = BPD.getInstance().getPackageEditor();
			optionsDialog = new ConfigDialog((JFrame) parent.getWindow());
		}
		return optionsDialog;
	}

	/**
	 * Call this to show the config dialog
	 */
	public void showConfigDialog() {
		optionsDialog.refresh();
		optionsDialog.setVisible(true);
		SwingUtilities.updateComponentTreeUI(ConfigDialog.getInstance());
	}

	private void refresh() {
		ArrayList cfgPanes = bpdOptionsRoot.getMembers();
		for (int i = 0; i < cfgPanes.size(); i++) {
			((BaseConfigPane) cfgPanes.get(i)).readConf();
		}
	}

	private ConfigDialog(Frame owner) {
		super(owner, ResourceManager
				.getLanguageDependentString("ConfigTitleLabel"), true);

		getContentPane().setLayout(new BorderLayout());
		((JPanel) getContentPane()).setBorder(BorderFactory.createEmptyBorder(
				5, 5, 5, 5));

		cardPanel = new JPanel(new CardLayout());// panel for every group of
													// options
		cardPanel.setBorder(BorderFactory.createLineBorder(Color.WHITE));
		getContentPane().add(cardPanel, BorderLayout.CENTER);

		paneTree = new JTree(treeModel = createbpdTreeModel());// panel for
																// tree
		paneTree.setCellRenderer(new PaneNameRenderer());
		paneTree.putClientProperty("JTree.lineStyle", "Angled");
		paneTree.setShowsRootHandles(true);
		paneTree.setFont(BPDConfig.getInstance().getFont());
		getContentPane().add(
				new JScrollPane(paneTree,
						JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
						JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED),
				BorderLayout.WEST);

		JPanel buttonsPanel = new JPanel();// panel for buttons

		okButton = new JButton(ResourceManager
				.getLanguageDependentString("OKKey"), new ImageIcon(
				ResourceManager.getResource("OKImage")));
		okButton.addActionListener(this);
		getRootPane().setDefaultButton(okButton);

		cancelButton = new JButton(ResourceManager
				.getLanguageDependentString("CancelKey"), new ImageIcon(
				ResourceManager.getResource("CancelImage")));
		cancelButton.addActionListener(this);

		applyButton = new JButton(ResourceManager
				.getLanguageDependentString("ApplyKey"), new ImageIcon(
				ResourceManager.getResource("ApplyImage")));
		applyButton.addActionListener(this);

		restoreDefaultButton = new JButton(ResourceManager
				.getLanguageDependentString("RestoreDefaultKey"),
				new ImageIcon(ResourceManager
						.getResource("RestoreDefaultImage")));
		restoreDefaultButton.addActionListener(this);

		buttonsPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
		buttonsPanel.add(okButton);
		buttonsPanel.add(cancelButton);
		buttonsPanel.add(applyButton);
		buttonsPanel.add(Box.createHorizontalStrut(10));
		buttonsPanel.add(restoreDefaultButton);
		getContentPane().add(buttonsPanel, BorderLayout.SOUTH);

		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				cancel();
			}
		});

		TreePath bpdPath = new TreePath(new Object[] { treeModel.getRoot(),
				bpdOptionsRoot.getMember(0) });
		paneTree.setSelectionPath(bpdPath);

		paneTree.getSelectionModel().addTreeSelectionListener(this);

		getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false), "Cancel");
		getRootPane().getActionMap().put("Cancel", new AbstractAction() {
			public void actionPerformed(ActionEvent e) {
				cancel();
			}
		});

		Utils.center(this, 100, 250);

	}

	private OptionTreeModel createbpdTreeModel() {

		bpdOptionsRoot = new ConfigElements("BPDConfiguration");

		OptionTreeModel bpdTreeModel = new OptionTreeModel(bpdOptionsRoot);
		addOptionPane(new CfgGeneral("General"), bpdOptionsRoot);
		addOptionPane(new CfgUI("UI"), bpdOptionsRoot);
		// addOptionPane(new CfgLDAP("LDAP"), bpdOptionsRoot);
		addOptionPane(new CfgColors("Color"), bpdOptionsRoot);
		addOptionPane(new CfgObjectSize("Size"), bpdOptionsRoot);

		return bpdTreeModel;
	}

	private void addOptionPane(BaseConfigPane child, ConfigElements parent) {
		String name = child.getName();
		// cardPanel.add(child.getComponent(),name);
		// cardPanel.add(child,name);
		configsPanel = new JPanel(new BorderLayout());
		configsPanel.add(child.getComponent(), BorderLayout.NORTH);
		cardPanel.add(new JScrollPane(configsPanel,
				JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
				JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED), name);

		parent.addOptionPane(child);
	}

	private void cancel() {
		optionsDialog.setVisible(false);
	}

	private void ok(boolean close) {
		OptionTreeModel m = (OptionTreeModel) paneTree.getModel();
		((ConfigElements) m.getRoot()).save();
		applyChanges();

		// If OK button is pressed
		if (close) {
			optionsDialog.setVisible(false);
		}
	}

	private void applyChanges() {
		OptionTreeModel m = (OptionTreeModel) paneTree.getModel();
		((ConfigElements) m.getRoot()).readConf();

		// Changes of L'n'F, status bar and grid size and status
		parent.refreshEditorConfiguration();
		/*
		 * ProcessEditor pe=BPD.getInstance().getActivedProcessEditor();
		 * pe.refreshEditorConfiguration();
		 */
		SwingUtilities.updateComponentTreeUI(ConfigDialog.getInstance());
		MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getPackageTreePanel()
				.refreshPackageTreePanel();
		MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getRemotePackageTreePanel()
		.refreshPackageTreePanel();
		BPDConfig.getInstance().saveConf();
	}

	/**
	 * Invoked when an action occurs.
	 */
	public void actionPerformed(ActionEvent e) {
		Object source = e.getSource();
		if (source == okButton) {
			ok(true);
		} else if (source == cancelButton) {
			cancel();
		} else if (source == applyButton) {
			ok(false);
		} else if (source == restoreDefaultButton) {
			BPDConfig.getInstance().restoreDefaultSettings();
			applyChanges();
		}
	}

	/**
	 * Called whenever the value of the selection changes.
	 * 
	 * @param evt
	 *            the event that characterizes the change.
	 */
	public void valueChanged(TreeSelectionEvent evt) {
		TreePath path = evt.getPath();

		if (path == null
				|| !(path.getLastPathComponent() instanceof BaseConfigPane))
			return;

		Object[] nodes = path.getPath();
		int lastIdx = nodes.length - 1;
		currPaneName = null;

		for (int i = paneTree.isRootVisible() ? 0 : 1; i <= lastIdx; i++) {
			if (nodes[i] instanceof BaseConfigPane) {
				currPaneName = ((BaseConfigPane) nodes[i]).getName();
			} else if (nodes[i] instanceof ConfigElements) {
				currPaneName = ((ConfigElements) nodes[i]).getName();
			} else {
				continue;
			}

		}
		((CardLayout) cardPanel.getLayout()).show(cardPanel, currPaneName);
	}

	public void refreshLanguageDependentStrings() {
		setTitle(ResourceManager.getLanguageDependentString("ConfigTitleLabel"));
		okButton.setText(ResourceManager.getLanguageDependentString("OKKey"));
		cancelButton.setText(ResourceManager
				.getLanguageDependentString("CancelKey"));
		applyButton.setText(ResourceManager
				.getLanguageDependentString("ApplyKey"));
		restoreDefaultButton.setText(ResourceManager
				.getLanguageDependentString("RestoreDefaultKey"));
		OptionTreeModel m = (OptionTreeModel) paneTree.getModel();
		((ConfigElements) m.getRoot()).refreshLanguageDependentStrings();
	}

	class PaneNameRenderer extends JLabel implements TreeCellRenderer {
		private Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1,
				1);

		private Border focusBorder = BorderFactory
				.createLineBorder(Color.ORANGE);

		private Font paneFont;

		private Font rootFont;

		public PaneNameRenderer() {
			setOpaque(true);

			paneFont = UIManager.getFont("Tree.font");
			rootFont = new Font(paneFont.getName(), paneFont.getStyle()
					| Font.BOLD, paneFont.getSize() + 1);
		}

		public Component getTreeCellRendererComponent(JTree tree, Object value,
				boolean selected, boolean expanded, boolean leaf, int row,
				boolean hasFocus) {

			if (selected) {
				this.setBackground(UIManager
						.getColor("Tree.selectionBackground"));
				this.setForeground(UIManager
						.getColor("Tree.selectionForeground"));
			} else {
				this.setBackground(tree.getBackground());
				this.setForeground(tree.getForeground());
			}

			String name = null;

			if (value instanceof ConfigElements) {
				name = ((ConfigElements) value).getName();
				this.setFont(rootFont);
			} else if (value instanceof BaseConfigPane) {
				name = ((BaseConfigPane) value).getName();
				this.setFont(paneFont);
			}

			if (name == null) {
				setText(null);
			} else {
				String label = ResourceManager
						.getLanguageDependentString("Config." + name + ".Label");

				if (label == null) {
					setText(name);
				} else {
					setText(label);
				}
			}

			setBorder(hasFocus ? focusBorder : noFocusBorder);
			return this;
		}
	}

	class OptionTreeModel implements TreeModel {

		private ConfigElements root;// = new OptionGroup("root");

		private EventListenerList listenerList = new EventListenerList();

		public OptionTreeModel(ConfigElements root) {
			this.root = root;
		}

		/**
		 * Messaged when the user has altered the value for the item identified
		 * by <code>path</code> to <code>newValue</code>. If
		 * <code>newValue</code> signifies a truly new value the model should
		 * post a <code>treeNodesChanged</code> event.
		 * 
		 * @param path
		 *            path to the node that the user has altered
		 * @param newValue
		 *            the new value from the TreeCellEditor
		 */
		public void valueForPathChanged(TreePath path, Object newValue) {

		}

		/**
		 * Returns the root of the tree. Returns <code>null</code> only if the
		 * tree has no nodes.
		 * 
		 * @return the root of the tree
		 */
		public Object getRoot() {
			return root;
		}

		/**
		 * Returns the index of child in parent. If <code>parent</code> is
		 * <code>null</code> or <code>child</code> is <code>null</code>,
		 * returns -1.
		 * 
		 * @param parent
		 *            a note in the tree, obtained from this data source
		 * @param child
		 *            the node we are interested in
		 * @return the index of the child in the parent, or -1 if either
		 *         <code>child</code> or <code>parent</code> are
		 *         <code>null</code>
		 */
		public int getIndexOfChild(Object parent, Object child) {
			if (parent instanceof ConfigElements) {
				return ((ConfigElements) parent).getMemberIndex(child);
			} else {
				return -1;
			}
		}

		/**
		 * Returns the child of <code>parent</code> at index
		 * <code>index</code> in the parent's child array. <code>parent</code>
		 * must be a node previously obtained from this data source. This should
		 * not return <code>null</code> if <code>index</code> is a valid
		 * index for <code>parent</code> (that is <code>index >= 0 &&
		 * index < getChildCount(parent</code>)).
		 * 
		 * @param parent
		 *            a node in the tree, obtained from this data source
		 * @return the child of <code>parent</code> at index
		 *         <code>index</code>
		 */
		public Object getChild(Object parent, int index) {
			if (parent instanceof ConfigElements) {
				return ((ConfigElements) parent).getMember(index);
			} else {
				return null;
			}
		}

		/**
		 * Removes a listener previously added with
		 * <code>addTreeModelListener</code>.
		 * 
		 * @see #addTreeModelListener
		 * @param l
		 *            the listener to remove
		 */
		public void removeTreeModelListener(TreeModelListener l) {
			listenerList.remove(TreeModelListener.class, l);
		}

		/**
		 * Returns the number of children of <code>parent</code>. Returns 0
		 * if the node is a leaf or if it has no children. <code>parent</code>
		 * must be a node previously obtained from this data source.
		 * 
		 * @param parent
		 *            a node in the tree, obtained from this data source
		 * @return the number of children of the node <code>parent</code>
		 */
		public int getChildCount(Object parent) {
			if (parent instanceof ConfigElements) {
				return ((ConfigElements) parent).getMemberCount();
			} else {
				return 0;
			}
		}

		/**
		 * Returns <code>true</code> if <code>node</code> is a leaf. It is
		 * possible for this method to return <code>false</code> even if
		 * <code>node</code> has no children. A directory in a filesystem, for
		 * example, may contain no files; the node representing the directory is
		 * not a leaf, but it also has no children.
		 * 
		 * @param node
		 *            a node in the tree, obtained from this data source
		 * @return true if <code>node</code> is a leaf
		 */
		public boolean isLeaf(Object node) {
			return node instanceof BaseConfigPane;
		}

		/**
		 * Adds a listener for the <code>TreeModelEvent</code> posted after
		 * the tree changes.
		 * 
		 * @param l
		 *            the listener to add
		 * @see #removeTreeModelListener
		 */
		public void addTreeModelListener(TreeModelListener l) {
			listenerList.add(TreeModelListener.class, l);
		}
	}

}
