/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：图形界面配置展现类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.config;

import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;

import com.ds.bpm.bpd.BPDConfig;

public class CfgUI extends BaseConfigPane {

	private JComboBox looknFeel;

	private JCheckBox tooltipStatus, jtreeExpandStatus, statusBarStatus;// gridStatus

	private JTextField txtGridSize;

	private String[] lnfNames = {"Liquid", "Metal", "Motif", "Windows", 
			"Native" };

	private String[] lnfClassNames = {
			"com.birosoft.liquid.LiquidLookAndFeel",
			"javax.swing.plaf.metal.MetalLookAndFeel",
			"com.sun.java.swing.plaf.motif.MotifLookAndFeel",
			"com.sun.java.swing.plaf.windows.WindowsLookAndFeel",
			 "" };

	public CfgUI(String name) {
		super(name);

		looknFeel = new JComboBox(lnfNames);
		addComponent("Config.UI.LnF.Label", looknFeel);

		tooltipStatus = new JCheckBox();
		addComponent("Config.UI.Tooltip.Label", tooltipStatus);

		/*
		 * gridStatus = new JCheckBox();
		 * addComponent("Config.UI.Grid.Label",gridStatus);
		 */

		statusBarStatus = new JCheckBox();
		addComponent("Config.UI.StatusBar.Label", statusBarStatus);

		jtreeExpandStatus = new JCheckBox();
		addComponent("Config.UI.JtreeExpand.Label", jtreeExpandStatus);

		/*
		 * txtGridSize = new JTextField();
		 * addComponent("Config.UI.GridSize.Label",txtGridSize );
		 */

		readConf();
	}

	public void readConf() {
		looknFeel.setSelectedItem(lfClassNameToName());
		tooltipStatus.setSelected(BPDConfig.getInstance().getTooltipStatus());
		// gridStatus.setSelected(BPDConfig.getInstance().getGridStatus());
		statusBarStatus.setSelected(BPDConfig.getInstance()
				.getStatusBarStatus());
		jtreeExpandStatus.setSelected(BPDConfig.getInstance()
				.getJTreeExpandStatus());
		// txtGridSize.setText(Integer.toString(BPDConfig.getInstance().getGridSize()));
	}

	public void save() {
		BPDConfig.getInstance().setLookAndFeelClassName(lfNameToClassName());
		BPDConfig.getInstance().setTooltipStatus(tooltipStatus.isSelected());
		// BPDConfig.getInstance().setGridStatus(gridStatus.isSelected());
		BPDConfig.getInstance()
				.setStatusBarStatus(statusBarStatus.isSelected());
		BPDConfig.getInstance().setJTreeExpandStatus(
				jtreeExpandStatus.isSelected());
		// BPDConfig.getInstance().setGridSize(Integer.parseInt(txtGridSize.getText()));
	}

	private String lfClassNameToName() {
		String lnfClassName = BPDConfig.getInstance().getLookAndFeelClassName();
		for (int i = 0; i < lnfClassNames.length; i++) {
			if (lnfClassNames[i].equals(lnfClassName)) {
				return lnfNames[i];
			}
		}
		return lnfNames[3];
	}

	private String lfNameToClassName() {
		String lnfName = looknFeel.getSelectedItem().toString();
		for (int i = 0; i < lnfNames.length; i++) {
			if (lnfNames[i].equals(lnfName)) {
				return lnfClassNames[i];
			}
		}
		return lnfClassNames[3];
	}

	public Component getComponent() {
		return this;
	}
}
