/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：通用配置展现类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.config;

import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;

public class CfgGeneral extends BaseConfigPane {

	private JTextField txtRecentList;

	private JComboBox startingLocale, conformanceClass;

	private JCheckBox validationStatus;

	// private String[] confClasses = {"", "FULL_BLOCKED", "LOOP_BLOCKED",
	// "NON_BLOCKED"};
	private String[] confClasses = { "FULL_BLOCKED" };

	public CfgGeneral(String name) {

		super(name);

		validationStatus = new JCheckBox();
		addComponent("Config.General.Validation.Label", validationStatus);

		/*
		 * startingLocale = new JComboBox(); refillStartingLanguageCombo();
		 * addComponent("Config.General.StartingLanguage.Label",startingLocale );
		 */

		/*
		 * conformanceClass =new JComboBox(); refillConformanceClassCombo();
		 * boolean
		 * mccst=BPDConfig.getInstance().getMandatoryConformanceClassSettingStatus();
		 * if (mccst) {
		 * addComponent("Config.General.MandatoryConformanceClass.Label",conformanceClass); }
		 * else { conformanceClass.setVisible(false); }
		 */

		txtRecentList = new JTextField();
		addComponent("Config.General.RecentFileListSize.Label", txtRecentList);

		readConf();
	}

	public void readConf() {
		validationStatus.setSelected(BPDConfig.getInstance()
				.getValidationStatus());
		// startingLocale.setSelectedItem(PFLocale.createPFLocale(BPDConfig.getInstance().getStartingLocale()));
		txtRecentList.setText(Integer.toString(BPDConfig.getInstance()
				.getRecentFileListSize()));
		// conformanceClass.setSelectedItem(ResourceManager.getLanguageDependentString(BPDConfig.getInstance().getMandatoryConformanceClass()+"Key"));
	}

	public void save() {
		BPDConfig.getInstance().setValidationStatus(
				validationStatus.isSelected());
		/*
		 * Object selSl=startingLocale.getSelectedItem(); if (selSl instanceof
		 * PFLocale) {
		 * BPDConfig.getInstance().setStartingLocale(((PFLocale)selSl).getLocaleString()); }
		 * else { BPDConfig.getInstance().setStartingLocale(""); }
		 */
		BPDConfig.getInstance().setRecentFileListSize(
				Integer.parseInt(txtRecentList.getText()));
		// BPDConfig.getInstance().setMandatoryConformanceClass(confClasses[conformanceClass.getSelectedIndex()]);
	}

	public Component getComponent() {
		return this;
	}

	public void refreshLanguageDependentStrings() {
		super.refreshLanguageDependentStrings();
		refillConformanceClassCombo();
		refillStartingLanguageCombo();
	}

	private void refillConformanceClassCombo() {
		conformanceClass.removeAllItems();
		// conformanceClass.addItem("");
		for (int i = 0; i < confClasses.length; i++) {
			conformanceClass.addItem(ResourceManager
					.getLanguageDependentString(confClasses[i] + "Key"));
		}
	}

	private void refillStartingLanguageCombo() {
		startingLocale.removeAllItems();
		startingLocale.addItem("");
		java.util.List pfs = Utils.findPropertyFiles();
		for (int i = 0; i < pfs.size(); i++) {
			startingLocale.addItem(pfs.get(i));
		}
	}

}
