/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：颜色配置面板展现类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;

public class CfgColors extends BaseConfigPane {

	private JTextField BackgroundColor, HighlightColor, HandleColor,
			MarqueeColor, GridColor, ProcessColor, TransitionColor,
			BackwardTransitionColor, ParticipantTextColor,
			ParticipantBorderColor, ResourceSetParticipantColor,
			ResourceParticipantColor, RoleParticipantColor,
			OrganizationalUnitParticipantColor, HumanParticipantColor,
			SystemParticipantColor, FreeTextExpressionParticipantColor,
			SelectedActivityColor, StartColor, EndColor, ManualActivityColor,
			AutoActivityColor, SubFlowActivityColor, BlockActivityColor,
			ActivityPreconditionColor, ActivityPostconditionColor;

	public CfgColors(String name) {
		super(name);

		BackgroundColor = new JTextField();
		addComponent("Config.Color.BackgroundColor.Label",
				drawPanel(BackgroundColor));
		HighlightColor = new JTextField();
		addComponent("Config.Color.HighlightColor.Label",
				drawPanel(HighlightColor));
		HandleColor = new JTextField();
		addComponent("Config.Color.HandleColor.Label", drawPanel(HandleColor));
		MarqueeColor = new JTextField();
		addComponent("Config.Color.MarqueeColor.Label", drawPanel(MarqueeColor));
		/*
		 * GridColor = new JTextField();
		 * addComponent("Config.Color.GridColor.Label",drawPanel(GridColor));
		 */
		/*
		 * ProcessColor = new JTextField();
		 * addComponent("Config.Color.ProcessColor.Label",drawPanel(ProcessColor) );
		 */
		TransitionColor = new JTextField();
		addComponent("Config.Color.TransitionColor.Label",
				drawPanel(TransitionColor));

		BackwardTransitionColor = new JTextField();
		addComponent("Config.Color.BackwardTransitionColor.Label",
				drawPanel(BackwardTransitionColor));
		/*
		 * ParticipantTextColor = new JTextField();
		 * addComponent("Config.Color.ParticipantTextColor.Label",drawPanel(ParticipantTextColor) );
		 * ParticipantBorderColor = new JTextField();
		 * addComponent("Config.Color.ParticipantBorderColor.Label",drawPanel(ParticipantBorderColor) );
		 * ResourceSetParticipantColor = new JTextField();
		 * addComponent("Config.Color.ResourceSetParticipantColor.Label",drawPanel(ResourceSetParticipantColor) );
		 * ResourceParticipantColor = new JTextField();
		 * addComponent("Config.Color.ResourceParticipantColor.Label",drawPanel(ResourceParticipantColor) );
		 * RoleParticipantColor = new JTextField();
		 * addComponent("Config.Color.RoleParticipantColor.Label",drawPanel(RoleParticipantColor) );
		 * OrganizationalUnitParticipantColor = new JTextField();
		 * addComponent("Config.Color.OrganizationalUnitParticipantColor.Label",drawPanel(OrganizationalUnitParticipantColor) );
		 * HumanParticipantColor = new JTextField();
		 * addComponent("Config.Color.HumanParticipantColor.Label",drawPanel(HumanParticipantColor) );
		 * SystemParticipantColor = new JTextField();
		 * addComponent("Config.Color.SystemParticipantColor.Label",drawPanel(SystemParticipantColor) );
		 * FreeTextExpressionParticipantColor = new JTextField();
		 * addComponent("Config.Color.FreeTextExpressionParticipantColor.Label",drawPanel(FreeTextExpressionParticipantColor) );
		 */
		SelectedActivityColor = new JTextField();
		addComponent("Config.Color.SelectedActivityColor.Label",
				drawPanel(SelectedActivityColor));
		StartColor = new JTextField();
		addComponent("Config.Color.StartColor.Label", drawPanel(StartColor));
		EndColor = new JTextField();
		addComponent("Config.Color.EndColor.Label", drawPanel(EndColor));
		ManualActivityColor = new JTextField();
		addComponent("Config.Color.ManualActivityColor.Label",
				drawPanel(ManualActivityColor));
		AutoActivityColor = new JTextField();
		addComponent("Config.Color.AutoActivityColor.Label",
				drawPanel(AutoActivityColor));
		SubFlowActivityColor = new JTextField();
		addComponent("Config.Color.SubFlowActivityColor.Label",
				drawPanel(SubFlowActivityColor));
		BlockActivityColor = new JTextField();
		addComponent("Config.Color.BlockActivityColor.Label",
				drawPanel(BlockActivityColor));
		ActivityPreconditionColor = new JTextField();
		addComponent("Config.Color.ActivityPreconditionColor.Label",
				drawPanel(ActivityPreconditionColor));
		ActivityPostconditionColor = new JTextField();
		addComponent("Config.Color.ActivityPostconditionColor.Label",
				drawPanel(ActivityPostconditionColor));
		readConf();
	}

	public void readConf() {
		String col = BPDConfig.getInstance().getBackgroundColor();
		setColorField(BackgroundColor, col);

		col = BPDConfig.getInstance().getHighlightColor();
		setColorField(HighlightColor, col);

		col = BPDConfig.getInstance().getHandleColor();
		setColorField(HandleColor, col);

		col = BPDConfig.getInstance().getMarqueeColor();
		setColorField(MarqueeColor, col);

		/*
		 * col=BPDConfig.getInstance().getGridColor();
		 * setColorField(GridColor,col);
		 */

		/*
		 * col=BPDConfig.getInstance().getProcessColor();
		 * setColorField(ProcessColor,col);
		 */

		col = BPDConfig.getInstance().getTransitionColor();
		setColorField(TransitionColor, col);

		col = BPDConfig.getInstance().getBackwardTransitionColor();
		setColorField(BackwardTransitionColor, col);

		/*
		 * col=BPDConfig.getInstance().getParticipantTextColor();
		 * setColorField(ParticipantTextColor,col);
		 * col=BPDConfig.getInstance().getParticipantBorderColor();
		 * setColorField(ParticipantBorderColor,col);
		 * col=BPDConfig.getInstance().getResourceSetParticipantColor();
		 * setColorField(ResourceSetParticipantColor,col);
		 * col=BPDConfig.getInstance().getResourceParticipantColor();
		 * setColorField(ResourceParticipantColor,col);
		 * col=BPDConfig.getInstance().getRoleParticipantColor();
		 * setColorField(RoleParticipantColor,col);
		 * col=BPDConfig.getInstance().getOrganizationalUnitParticipantColor();
		 * setColorField(OrganizationalUnitParticipantColor,col);
		 * col=BPDConfig.getInstance().getHumanParticipantColor();
		 * setColorField(HumanParticipantColor,col);
		 * col=BPDConfig.getInstance().getSystemParticipantColor();
		 * setColorField(SystemParticipantColor,col);
		 * col=BPDConfig.getInstance().getFreeTextExpressionParticipantColor();
		 * setColorField(FreeTextExpressionParticipantColor,col);
		 */

		col = BPDConfig.getInstance().getSelectedActivityColor();
		setColorField(SelectedActivityColor, col);

		col = BPDConfig.getInstance().getStartColor();
		setColorField(StartColor, col);

		col = BPDConfig.getInstance().getEndColor();
		setColorField(EndColor, col);

		col = BPDConfig.getInstance().getManualActivityColor();
		setColorField(ManualActivityColor, col);

		col = BPDConfig.getInstance().getAutoActivityColor();
		setColorField(AutoActivityColor, col);

		col = BPDConfig.getInstance().getSubFlowActivityColor();
		setColorField(SubFlowActivityColor, col);

		col = BPDConfig.getInstance().getBlockActivityColor();
		setColorField(BlockActivityColor, col);

		col = BPDConfig.getInstance().getActivityPreconditionColor();
		setColorField(ActivityPreconditionColor, col);

		col = BPDConfig.getInstance().getActivityPostconditionColor();
		setColorField(ActivityPostconditionColor, col);

	}

	public void save() {
		// System.out.println("Snimam Colors");
		BPDConfig.getInstance().setBackgroundColor(BackgroundColor.getText());
		BPDConfig.getInstance().setHighlightColor(HighlightColor.getText());
		BPDConfig.getInstance().setHandleColor(HandleColor.getText());
		BPDConfig.getInstance().setMarqueeColor(MarqueeColor.getText());
		// BPDConfig.getInstance().setGridColor(GridColor.getText());
		// BPDConfig.getInstance().setProcessColor(ProcessColor.getText());
		BPDConfig.getInstance().setTransitionColor(TransitionColor.getText());
		BPDConfig.getInstance().setBackwardTransitionColor(
				BackwardTransitionColor.getText());

		/*
		 * BPDConfig.getInstance().setParticipantTextColor(ParticipantTextColor.getText());
		 * BPDConfig.getInstance().setParticipantBorderColor(ParticipantBorderColor.getText());
		 * BPDConfig.getInstance().setResourceSetParticipantColor(ResourceSetParticipantColor.getText());
		 * BPDConfig.getInstance().setResourceParticipantColor(ResourceParticipantColor.getText());
		 * BPDConfig.getInstance().setRoleParticipantColor(RoleParticipantColor.getText());
		 * BPDConfig.getInstance().setOrganizationalUnitParticipantColor(OrganizationalUnitParticipantColor.getText());
		 * BPDConfig.getInstance().setHumanParticipantColor(HumanParticipantColor.getText());
		 * BPDConfig.getInstance().setSystemParticipantColor(SystemParticipantColor.getText());
		 * BPDConfig.getInstance().setFreeTextExpressionParticipantColor(FreeTextExpressionParticipantColor.getText());
		 */
		BPDConfig.getInstance().setSelectedActivityColor(
				SelectedActivityColor.getText());
		BPDConfig.getInstance().setStartColor(StartColor.getText());
		BPDConfig.getInstance().setEndColor(EndColor.getText());
		BPDConfig.getInstance().setManualActivityColor(
				ManualActivityColor.getText());
		BPDConfig.getInstance().setAutoActivityColor(
				AutoActivityColor.getText());
		BPDConfig.getInstance().setSubFlowActivityColor(
				SubFlowActivityColor.getText());
		BPDConfig.getInstance().setBlockActivityColor(
				BlockActivityColor.getText());
		BPDConfig.getInstance().setActivityPreconditionColor(
				ActivityPreconditionColor.getText());
		BPDConfig.getInstance().setActivityPostconditionColor(
				ActivityPostconditionColor.getText());
	}

	private String getColorString(Color c) {
		String color = "R=" + Integer.toString(c.getRed());
		color += ",G=" + Integer.toString(c.getGreen());
		color += ",B=" + Integer.toString(c.getBlue());
		return color;
	}

	private JPanel drawPanel(final JTextField field) {
		JPanel panelColor = new JPanel(new BorderLayout());
		JButton buttColor = new JButton(new ImageIcon(ResourceManager
				.getResource("ColorImage")));
		buttColor.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				Color newColor = JColorChooser
						.showDialog(
								CfgColors.this,
								ResourceManager
										.getLanguageDependentString("Config.Color.ColorChoosePanel.Label"),
								Utils.getColor(field.getText()));
				if (newColor != null) {
					setColorField(field, getColorString(newColor));
				}

			}
		});
		panelColor.add(field, BorderLayout.CENTER);
		panelColor.add(buttColor, BorderLayout.EAST);
		return panelColor;
	}

	private void setColorField(JTextField cf, String col) {
		cf.setText(col);
		cf.setBackground(Utils.getColor(col));
		cf.setToolTipText(col);
	}

	public Component getComponent() {
		return this;
	}

}
