/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：主界面配置面板的构造基类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import com.ds.bpm.bpd.ResourceManager;

public class BaseConfigPane extends JPanel {

	private String name;

	protected int y = 0;

	protected GridBagLayout gridBag;

	protected Map componentToPropertyFileEntry = new HashMap();

	/**
	 * Constructor
	 */
	public BaseConfigPane(String name) {
		this.name = name;
		setLayout(gridBag = new GridBagLayout());
		setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
	}

	public String getName() {
		return name;
	}

	public Component getComponent() {
		return this;
	}

	/**
	 * Adds a labeled component in the pane. All the components are placed on
	 * bottom of each other (vertically sorted).
	 * 
	 * @param cfEntry
	 *            The label to be displayed next to the component
	 * @param comp
	 *            The component to be added
	 */
	protected void addComponent(String cfEntry, Component comp) {
		GridBagConstraints cons = new GridBagConstraints();

		cons.gridy = y++;
		cons.gridx = 0;

		cons.gridheight = 1;
		cons.gridwidth = 1;

		cons.weightx = 1.0f;

		// cons.anchor = GridBagConstraints.WEST;
		cons.anchor = GridBagConstraints.EAST;
		cons.fill = GridBagConstraints.HORIZONTAL;
		// cons.fill = GridBagConstraints.NONE;

		String label = ResourceManager.getLanguageDependentString(cfEntry)
				+ ": ";
		JLabel l = new JLabel(label, SwingConstants.RIGHT);
		componentToPropertyFileEntry.put(l, cfEntry);

		gridBag.setConstraints(l, cons);
		// if
		// (!cfEntry.equals("Config.General.MandatoryConformanceClass.Label")) {
		add(l);
		// }

		cons.gridx = 1;

		// cons.gridwidth = 1;

		// cons.anchor = GridBagConstraints.EAST;
		// cons.anchor = GridBagConstraints.WEST;

		gridBag.setConstraints(comp, cons);
		add(comp);
	}

	public void save() {
	}

	public void readConf() {
	}

	public void refreshLanguageDependentStrings() {
		Iterator it = componentToPropertyFileEntry.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry me = (Map.Entry) it.next();
			Component c = (Component) me.getKey();
			String cfe = (String) me.getValue();
			((JLabel) c).setText(ResourceManager
					.getLanguageDependentString(cfe)
					+ ": ");
		}
	}

}
