package com.ds.bpm.bpd.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginManager;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.XMLSimpleElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.enums.process.ProcessDefAccess;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.CParameter;
import com.ds.config.PluginType;
import com.ds.config.BPDProjectConfig;
import com.ds.iot.json.UserInfo;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 工作流所属应用数据类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2010
 * </p>
 * <p>
 * Company: itjds
 * </p>
 *
 * @author wenzhangli
 * @version 3.0
 */
public class ApplicationPanel extends XMLComplexElement {

    private static transient Log logger = LogFactory.getLog(BPDConstants.APPLICATION_NAME, ApplicationPanel.class);

    // 应用属性
    private XMLAttribute attrSystemCode;

    // 流程类别
    String accessLevelValue = ResourceManager.getLanguageDependentString("Process.General.AccessLevel.Value");

    String[] array_al = Utils.tokenize(accessLevelValue, " ");

    private XMLAttribute attrAccessLevel = new XMLAttribute("AccessLevel", new Object[]{new String[]{array_al[0], ProcessDefAccess.Public.getType()}, new String[]{array_al[1], ProcessDefAccess.Private.getType()}}, 0);

    private transient Map plugins;

    private transient List panels;

    private XMLAttribute attrClassification = new XMLAttribute(PluginType.Classification.getType());

    private XMLSimpleElement adminService = new XMLSimpleElement();

    private XMLSimpleElement dataService = new XMLSimpleElement();

    private XMLSimpleElement rightService = new XMLSimpleElement();

    private AppConfigManager manager = AppConfigManager.getInstance();

    private String systemCode;

    private String classificationName;

    public ApplicationPanel(String systemCode, String classificationName) {
        String[][] apps = manager.getApps();
        this.systemCode = systemCode;
        this.classificationName = classificationName;
        ;
        if (apps != null && apps.length > 0) {
            attrSystemCode = new XMLAttribute("SystemCode", apps, 0) {
                public void itemChanged(Object o) {
                    XMLSelectOption selectOption = (XMLSelectOption) o;
                    String textname = selectOption.getText();
                    setClassifications(textname);

                }
            };
        }
        attrSystemCode.setLabelName(ResourceManager.getLanguageDependentString("Process.General.SystemCode.display"));

        attrAccessLevel.setLabelName(ResourceManager.getLanguageDependentString("Process.General.AccessLevel.display"));
        attrAccessLevel.setVisible(false);
        attrClassification.setLabelName(ResourceManager.getLanguageDependentString("Process.General.Classification.display"));
        adminService.setLabelName("管理引擎接口");
        adminService.setReadOnly(true);
        if (manager.getApplicationMap().get(systemCode).getAdminService() != null) {
            adminService.setValue(manager.getApplicationMap().get(systemCode).getAdminService().getImplementation());
        }

        dataService.setLabelName("数据引擎");
        dataService.setValue(manager.getApplicationMap().get(systemCode).getDataEngine().getImplementation());
        dataService.setReadOnly(true);
        rightService.setLabelName("权限引擎");
        if (manager.getApplicationMap().get(systemCode).getRightEngine() != null) {
            rightService.setValue(manager.getApplicationMap().get(systemCode).getRightEngine().getImplementation());
        }
        rightService.setReadOnly(true);
        fillStructure();
        setClassifications(apps[0][1]);
        if (systemCode != null) {
            this.attrSystemCode.setValue(systemCode);
        }
        if (classificationName != null) {
            this.attrClassification.setValue(classificationName);
        }
        attrSystemCode.setReadOnly(true);
        attrClassification.setReadOnly(true);
        this.loadPlugins();
    }

    protected void fillStructure() {
        complexStructure.add(attrSystemCode);
        complexStructure.add(attrAccessLevel);
        complexStructure.add(attrClassification);

    }

    public XMLPanel getPanel() {
        // just to display type of activity
        XMLAttribute tp = new XMLAttribute("Type");
        tp.setLabelName(ResourceManager.getLanguageDependentString("Activity.General.Type.display"));
        tp.setValue("应用属性");
        tp.setReadOnly(true);

        XMLPanel p1 = new XMLGroupPanel(this, new XMLElement[]{attrSystemCode, attrAccessLevel, attrClassification, adminService, dataService, rightService}, ResourceManager.getLanguageDependentString("Activity.General.display"));
        panels = new ArrayList();
        panels.add(p1);

        if (plugins != null) {
            for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry entry = (Map.Entry) it.next();
                PluginElement pluginElement = (PluginElement) entry.getValue();
                panels.add(pluginElement.getPanel());
            }
        }


        XMLTabbedPanel p;
        p = new XMLTabbedPanel(this, (XMLPanel[]) panels.toArray(new XMLPanel[]{}));
        return p;
    }

    private void loadPlugins() {
        // 读取活动插件
        try {

            PluginManager pluginsmanager = PluginManager.getInstance(this.attrSystemCode.toValue().toString(), attrClassification.toValue().toString());
            plugins = pluginsmanager.getPlugins(PluginType.Classification, null);
            for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry entry = (Map.Entry) it.next();
                PluginElement pe = (PluginElement) entry.getValue();
                pe.setType(PluginType.Classification);

                BPDProjectConfig classification = AppConfigManager.getInstance().getApplicationMap().get(systemCode).getBPDProjectConfigMap().get(classificationName);
                pe.setProperty(PluginType.Classification.getType(), classification);
                pe.setBpdElement(pluginsmanager.getBPDElement((String) entry.getKey()));
                Map params = pluginsmanager.getPluginParams((String) entry.getKey());

                for (Iterator paramIt = params.entrySet().iterator(); paramIt.hasNext(); ) {
                    Map.Entry param = (Map.Entry) paramIt.next();
                    pe.setProperty((String) param.getKey(), ((CParameter) param.getValue()).getParameterValue());
                }
                pe.loadProperties();
                // plugins.put((String) entry.getKey(), pe);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    // 设置可配置的项目信息
    public void setClassifications(String appName) {
        UserInfo user = BPD.getInstance().getUserInfo();
        if (user != null) {
            List<BPDProjectConfig> classifications = AppConfigManager.getInstance().getProcessClassifications(appName, user.getId());
            if (classifications != null && classifications.size() > 0) {

                String[][] flowArr = new String[classifications.size()][2];
                int i = 0;
                for (BPDProjectConfig classification : classifications) {
                    flowArr[i] = new String[]{classification.getName(), classification.getCode()};
                    i = i + 1;
                }

                attrClassification = new XMLAttribute(PluginType.Classification.getType(), flowArr, 0);
                int index = getIndex(PluginType.Classification.getType());
                if (index != -1) {
                    complexStructure.set(index, attrClassification);
                } else {
                    complexStructure.add(attrClassification);
                }

            }
            attrClassification.setLabelName(ResourceManager.getLanguageDependentString("Process.General.Classification.display"));
        }
    }

    public void setVisible(String name, boolean flag) {
        XMLElement e = get(name);
        if (e != null) {
            e.setVisible(flag);
        }
    }

    // 实现clone方法
    public Object clone() {
        ApplicationPanel wf = (ApplicationPanel) super.clone();
        wf.attrAccessLevel = (XMLAttribute) this.attrAccessLevel.clone();
        wf.attrSystemCode = (XMLAttribute) this.attrSystemCode.clone();
        wf.attrClassification = (XMLAttribute) this.attrClassification.clone();
        wf.fillStructure();
        return wf;
    }
}
