
package com.ds.bpm.bpd.config;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.BPDProjectConfig;
import com.ds.config.CApplication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppConfigManager implements Serializable {

    private static transient Log logger = LogFactory.getLog(BPDConstants.APPLICATION_NAME, AppConfigManager.class);

    private Map<String, CApplication> applicationMap = new HashMap<String, CApplication>();

    // 引擎发布应用
    private List<CApplication> apps;

    private static AppConfigManager manager;

    AppConfigManager() {

        this.apps = getApplicationsFromWS();
        for (CApplication app : apps) {
            applicationMap.put(app.getSysId(), app);
        }

    }

    public static AppConfigManager getInstance() {
        if (manager == null) {
            manager = new AppConfigManager();
        }
        return manager;
    }

    public Map<String, CApplication> getApplicationMap() {
        return applicationMap;
    }

    // 查询WebService服务得到引擎发布的所有应用
    private List<CApplication> getApplicationsFromWS() {
        if (BPD.getInstance().getUserInfo() == null) {
            return null;
        }

        List<CApplication> apps = new ArrayList<CApplication>();


        try {
            apps = BPD.getInstance().getBPDService().getAppLications();
        } catch (JDSException e) {
            BPD.getInstance().getBPDService().handleWebServiceException(e);
        }
        return apps;

    }


    public List<BPDProjectConfig> getProcessClassifications(String sysCode, String personId) {
        if (BPD.getInstance().getUserInfo() == null) {
            return null;
        }

        List<BPDProjectConfig> flowTyps = new ArrayList<BPDProjectConfig>();

        try {
            flowTyps = BPD.getInstance().getBPDService().getProcessClassifications();
        } catch (JDSException e) {
            BPD.getInstance().getBPDService().handleWebServiceException(e);
        }
        return flowTyps;
    }

    public String[][] getApps() {
        List<CApplication> apps = getApplicationsFromWS();
        String[][] appArr = new String[apps.size()][2];
        int i = 0;
        for (CApplication app : apps) {
            appArr[i] = new String[]{app.getName(),app.getSysId()};
            i = i + 1;
        }
        return appArr;
    }
}
