/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JDialog;
import javax.swing.JFrame;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
* Class that realizes <B>workflow relevat data</B> action.
*/
public class WorkflowRelevantData extends ActionBase {

   public WorkflowRelevantData (AbstractEditor editor) {
      super(editor);
   }

   public void actionPerformed(ActionEvent e) {
      XMLPanel p;
      XMLElementDialog d;

      if (!(editor instanceof PackageEditor)) {
         com.ds.bpm.bpd.xml.elements.WorkflowProcess wp=
               (com.ds.bpm.bpd.xml.elements.WorkflowProcess)
               editor.getGraph().getPropertyObject();
         p=wp.getPanel(6);
         d=new XMLElementDialog((JDialog)editor.getWindow(),
               ResourceManager.getLanguageDependentString("ProcessKey")+" '"+
               wp.toString()+"' - "+
               ResourceManager.getLanguageDependentString("DataFieldsKey"));
      } else {
         PackageEditor pe=(PackageEditor)editor;
         if (!pe.isInitialized()) {
            pe.enterPackageID();
         }
         p=pe.getXMLPackage().getPanel(8);
         d=new XMLElementDialog((JFrame)pe.getWindow(),
               ResourceManager.getLanguageDependentString("PackageKey")+" '"+
               pe.getXMLPackage().get("Id").toString()+"' - "+
               ResourceManager.getLanguageDependentString("DataFieldsKey"));
      }
      d.editXMLElement(p,false,false);
   }
}

