/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：查看用户自定义属性的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JFrame;

import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Class that realizes <B>user defined activity properties</B> action.
 */
public class UserDefinedProperties extends ActionBase {

	public UserDefinedProperties(PackageEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		PackageEditor pe = (PackageEditor) editor;
		if (!pe.isInitialized()) {
			pe.enterPackageID();
		}
		XMLPanel p = pe.getXMLPackage().getPanel(10);
		XMLElementDialog d = new XMLElementDialog(
				(JFrame) pe.getWindow(),
				ResourceManager.getLanguageDependentString("PackageKey")
						+ " '"
						+ pe.getXMLPackage().get("Id").toString()
						+ "' - "
						+ ResourceManager
								.getLanguageDependentString("UserPropertiesKey"));
		d.editXMLElement(p, false, false);

	}
}
