/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：撤销的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;
import java.util.Set;

import javax.swing.Action;
import javax.swing.undo.CannotUndoException;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDGraphModel;
import com.ds.bpm.bpd.ResourceManager;

/**
 * Class that realizes <B>undo</B> action
 */
public class Undo extends ActionBase {

	public Undo(AbstractEditor editor) {
		super(editor);
		setEnabled(false);
	}

	public void actionPerformed(ActionEvent e) {
		if (BPD.getInstance().getActivedProcessEditor() != null) {
			try {
				Set s1 = BPDGraphModel.getAllCellsInModel(BPD.getInstance()
						.getActivedProcessEditor().getGraph().getModel());
				BPD.getInstance().getActivedProcessEditor().getUndoManager()
						.undo(
								BPD.getInstance().getActivedProcessEditor()
										.getGraph().getGraphLayoutCache());
				Set s2 = BPDGraphModel.getAllCellsInModel(BPD.getInstance()
						.getActivedProcessEditor().getGraph().getModel());
				BPD.getInstance().getActivedProcessEditor().refreshCollections(
						s1, s2);
			} catch (CannotUndoException ex) {
				System.err.println("Unable to undo: " + ex);
				ex.printStackTrace();
			}
			editor.update();
			editor.getRedo().update();
			BPD.getInstance().getActivedProcessEditor().getGraph().repaint();
			// graph.getUI().paint(graph.getGraphics(),graph);
		}
	}

	public void update() {
		if (BPD.getInstance().getActivedProcessEditor() != null) {
			if (BPD.getInstance().getActivedProcessEditor().getUndoManager()
					.canUndo(
							BPD.getInstance().getActivedProcessEditor()
									.getGraph().getGraphLayoutCache())) {
				setEnabled(true);
				putValue(Action.NAME, BPD.getInstance()
						.getActivedProcessEditor().getUndoManager()
						.getUndoPresentationName());
				editor.getToolbarComponent("Undo").setToolTipText(
						BPD.getInstance().getActivedProcessEditor()
								.getUndoManager().getUndoPresentationName());
			} else {
				setEnabled(false);
				putValue(Action.NAME, ResourceManager
						.getLanguageDependentString("UndoLabel"));
			}
		}
	}
}
