/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JFrame;

import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Class that realizes <B>type declarations</B> action.
 */
public class TypeDeclarations extends ActionBase {

	public TypeDeclarations(PackageEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		PackageEditor pe = (PackageEditor) editor;
		if (!pe.isInitialized()) {
			pe.enterPackageID();
		}
		XMLPanel p = pe.getXMLPackage().getPanel(5);

		XMLElementDialog d = new XMLElementDialog(
				(JFrame) pe.getWindow(),
				ResourceManager.getLanguageDependentString("PackageKey")
						+ " '"
						+ pe.getXMLPackage().get("Id").toString()
						+ "' - "
						+ ResourceManager
								.getLanguageDependentString("TypeDeclarationsKey"));
		d.editXMLElement(p, false, false);
	}
}
