/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：将路由变换为非自适应路由的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDGraphModel;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.graph.NoRouting;
import com.ds.bpm.bpd.graph.Transition;

import org.jgraph.graph.GraphConstants;

/**
 * Class that realizes <B>SetSimpleRouting</B> action.
 */
public class SetNoRouting extends ActionBase {

	public SetNoRouting(PackageEditor pe) {
		super(pe);
	}

	public void actionPerformed(ActionEvent e) {
		Object transition = BPD.getInstance().getActivedProcessEditor()
				.getGraph().getSelectionCell();
		if (transition instanceof Transition) {
			// updating xml object
			Transition tr = (Transition) transition;
			Map propertyMap = new HashMap();
			Map map = GraphConstants.cloneMap(tr.getAttributes());
			GraphConstants.setRouting(map, new NoRouting());
			propertyMap.put(tr, map);
			String undoMsg = ResourceManager
					.getLanguageDependentString("MessageSettingTransitionTypeToNoRouting");
			((BPDGraphModel) BPD.getInstance().getActivedProcessEditor()
					.getGraph().getModel()).insertAndEdit(null, propertyMap,
					null, null, null, undoMsg);
		}
	}
}
