/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：登录服务器的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */
package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Set;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDGraphModel;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ProcessGraph;
import com.ds.bpm.bpd.graph.Activity;
import com.ds.bpm.bpd.graph.Transition;

/**
 * Class that realizes <B>open</B> action.
 */
public class SelectAllCell extends ActionBase {
	public SelectAllCell(PackageEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		ProcessGraph processGraph = ((ProcessGraph) BPD.getInstance()
				.getActivedProcessEditor().getGraph());
		// 选择所有图形元素
		Set allCells = BPDGraphModel
				.getAllCellsInModel(processGraph.getModel());
		if (allCells != null) {
			Iterator it = allCells.iterator();
			while (it.hasNext()) {
				Object cell = it.next();
				if (cell instanceof Activity || cell instanceof Transition) {
					processGraph.addSelectionCell(cell);
				}
			}
		}
	}
}
