/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：另存当前编辑工作流为JPG图片的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.AbstractGraph;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;

public class SaveAsJPG extends ActionBase {

	public SaveAsJPG(AbstractEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {




		try {
			String file = BPD.getInstance().saveDialog(
					ResourceManager
							.getLanguageDependentString("SaveAsJPGLabel"),
					1,
					BPD.getInstance().getActivedProcessEditor().getGraph().get(
							"Name").toString());
			if (file != null && file.length() > 0) {
				BufferedImage img = getImage();
				FileOutputStream fos = new FileOutputStream(file);
//				JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(fos);
//				encoder.encode(img);
				fos.flush();
				fos.close();
			}
		} catch (IOException ex) {
			String msg = ResourceManager
					.getLanguageDependentString("ErrorJPGSavingFailed");
			BPD.getInstance().message(msg, JOptionPane.WARNING_MESSAGE);
		}
	}

	// Create a buffered image of the specified graph.
	private BufferedImage getImage() {
		AbstractGraph graph = BPD.getInstance().getActivedProcessEditor()
				.getGraph();
		Object[] cells = graph.getRoots();

		if (cells.length > 0) {
			Rectangle bounds = graph.getCellBounds(cells).getBounds();
			graph.toScreen(bounds);

			// Create a Buffered Image
			Dimension d = bounds.getSize();
			BufferedImage img = new BufferedImage(d.width, d.height,
					BufferedImage.TYPE_INT_RGB);
			Graphics2D graphics = img.createGraphics();
			graph.paint(graphics);

			return img;
		}
		return null;
	}

}
