/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：保存当前编辑工作流的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import com.ds.bpm.bpd.*;
import com.ds.bpm.bpd.graph.*;
import com.ds.bpm.bpd.misc.ValidationErrorDisplay;
import com.ds.bpm.bpd.xml.Path;
import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ExternalPackage;
import com.ds.bpm.bpd.xml.elements.PackageHeader;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.WorkflowProcesses;
import org.w3c.dom.Document;

import javax.swing.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.io.*;
import java.nio.channels.FileLock;
import java.util.*;

/**
 * Class that realizes <B>save</B> action. 保存操作
 */
public class Save extends ActionBase {

	public Save(PackageEditor editor) {
		super(editor);
		this.setEnabled(false);
	}

	public Save(PackageEditor editor, String name) {
		super(editor, name);
	}

	public void actionPerformed(ActionEvent e) {
		// 如果流程不合法，则不准许保存
		// if (validateWorkflowProcess()) {
		String processFlag = BPD.getInstance().getActivedProcessEditor()
				.getProcessFlag();

		WorkflowProcess wp = (WorkflowProcess) BPD.getInstance()
				.getActivedProcessEditor().getGraph().getPropertyObject();
		if (!wp.isSubFlow()) {
			if (BPD.getInstance().getActivedProcessEditor()
					.getProcessModified()
					|| e.getActionCommand().equals("SaveAs")) {
				// 保存前，以当前登录的编辑用户作为流程创建人或修改人
//				BPD.getInstance().getActivedProcessEditor()
//						.setLoginedUserForProcess();
				// 是否将当前编辑流程保存到本地

				if (processFlag == null || e == null
						|| e.getActionCommand().equals("SaveAs")) {
					// 如果当前编辑流程是新建的，那么提示用户是保存本地还是远端服务器
					int flag = JOptionPane
							.showConfirmDialog(
									editor.getWindow(),
									ResourceManager
											.getLanguageDependentString("MessageIsSaveToServer"),
									BPD.getAppTitle(),
									JOptionPane.YES_NO_CANCEL_OPTION);
					if (flag == JOptionPane.YES_OPTION) {
						editor
								.getAction(
										Utils
												.getUnqualifiedClassName(SaveToServer.class))
								.actionPerformed(e);
					} else if (flag == JOptionPane.NO_OPTION) {
						saveDocumentIfPossible(e);
					} else {
						return;
					}
				}
			}
	

		 }
		else {
			if (processFlag.equals(BPDConstants.PROCESS_LOCAL)) {
				// 如果当前流程以前是保存在本地的，那么默认存在本地
				saveDocumentIfPossible(e);
			} else if (processFlag.equals(BPDConstants.PROCESS_REMOTE)) {
				// 如果当前流程以前是保存在远端的，那么默认存在远端
				editor.getAction(
						Utils.getUnqualifiedClassName(SaveToServer.class))
						.actionPerformed(e);
			}
		}
		//}
	}

	/*
	 * } else { String msg = ResourceManager.getLanguageDependentString(
	 * "ErrorCannotSaveIncorrectPackage"); BPD.getInstance().message(msg,
	 * JOptionPane.ERROR_MESSAGE); }
	 */

	// 具体执行保存操作（保存本地文件）
	private void saveDocumentIfPossible(ActionEvent e) {
		PackageEditor pkgEditor = (PackageEditor) editor;
		String oldFilename = BPD.getInstance().getFilename();
		// 获得保存文件名
		//if (oldFilename == null) {
			String dialogTitle = "";
			if (e == null || e.getActionCommand().equals("Save")) {
				dialogTitle = ResourceManager
						.getLanguageDependentString("SaveDialog");
			} else if (e.getActionCommand().equals("SaveAs")) {
				dialogTitle = ResourceManager
						.getLanguageDependentString("SaveAsDialog");
			}
			String fileName = BPD.getInstance().saveDialog(
					dialogTitle,
					0,
					BPD.getInstance().getActivedProcessEditor().getGraph().get(
							"Name").toString());
			BPD.getInstance().setFilename(fileName);
		//}
		String newFilename = BPD.getInstance().getFilename();
		if (newFilename != null) {
			try {

				// com.ds.bpm.bpd.xml.elements.Package pkg =
				// packageEditor.getRealXMLPackage();
				com.ds.bpm.bpd.xml.elements.Package pkg = BPD
						.getInstance().getActivedProcessEditor().getGraph()
						.getXMLPackage();

				// The extended attributes for all package elements must
				// be updated.
				Save.updateExtendedAttributesForWorkflowProcesses(pkg);
				// set the XPDL version to 1.0
				PackageHeader ph = (PackageHeader) pkg.get("PackageHeader");
				ph.set("XPDLVersion", "1.0");
				Document document = null;
				DocumentBuilderFactory dbf = DocumentBuilderFactory
						.newInstance();
				DocumentBuilder dbuilder = dbf.newDocumentBuilder();
				document = dbuilder.newDocument();

				// retrieve the file writter
				  RandomAccessFile raf=null;
	               if (BPD.getInstance().getXMLInterface() instanceof XML) {
	                  raf=((XML)BPD.getInstance().getXMLInterface()).getRaf(pkg);
	               }

				//RandomAccessFile raf = XMLUtil.getRaf(pkg);

				// output stream will either be the FileOutputStream in the
				// case of save as, or the ByteArrayOutputStream if we are
				// saving an existing file
				OutputStream os;
				if (oldFilename == null) {
					// try to open random access file as rw, if it fails
					// the saving shouldn't occur
					try {
						File f = new File(newFilename);
						RandomAccessFile r = new RandomAccessFile(f, "rw");
						FileLock flck = r.getChannel().tryLock();
						flck.release();
						// this exception happens when using jdk1.4 under Linux
						// if it happens, just catch it and proceed with saving
						// because Linux with jdk1.4.0 doesn't support locking
					} catch (IOException ioe) {
						// this happens when the locking fails, and null is
						// returned,
						// and after that release method is called on the null;
						// This means that the file we want to save the given
						// package as, is already locked, so we do not allow
						// saving
					} catch (NullPointerException npe) {
						BPD.getInstance().setFilename(null);
						throw new Exception();
					}
					// if we are at this point, this means either the locking
					// succeeded, or we use jdk1.4 under Linux that does not
					// support locking
					os = new FileOutputStream(newFilename);
				} else {
					os = new ByteArrayOutputStream();
				}

				// Here we get all document elements set
				pkg.toXML(document);

				// Use a Transformer for output
				TransformerFactory tFactory = TransformerFactory.newInstance();
				Transformer transformer = tFactory.newTransformer();
				transformer.setOutputProperty("indent", "yes");
				transformer.setOutputProperty(
						"{http://xml.apache.org/xslt}indent-amount", "4");
				transformer.setOutputProperty("encoding","utf-8");
				DOMSource source = new DOMSource(document);
				StreamResult result = new StreamResult(os);
				transformer.transform(source, result);
				if (oldFilename != null) {
					// must go to the begining - otherwise, it will not
					// truncate the file correctly in some Java-OS combination
					raf.seek(0);
					raf.getChannel().truncate(0);
					raf.write(((ByteArrayOutputStream) os).toByteArray());
				}
				os.close();



				// 记录打开的流程
				if (oldFilename == null) {
					BPD.getInstance().getXMLInterface().registerPackageFilename(newFilename, pkg);
				}
				try {
					System.setProperty("user.dir", BPD.getInstance().getXMLInterface().getParentDirectory(pkg));
				} catch (Exception ex) {
				}
				try {
					BPD.getInstance().addToRecentFiles(newFilename);
				} catch (Exception ex) {
				}

				// 设置流程标识为保存在本地
				BPD.getInstance().getActivedProcessEditor().setProcessFlag(
						BPDConstants.PROCESS_LOCAL);
				// 将工作流图形设置为没有改变
				BPD.getInstance().getActivedProcessEditor().setProcessModified(
						false);
				// 将保存的流程存入本地流程集合
				Iterator wpCln = ((WorkflowProcesses) pkg
						.get("WorkflowProcesses")).toCollection().iterator();
				if (wpCln.hasNext()) {
					WorkflowProcess wp = (WorkflowProcess) wpCln.next();
					String processDefVersionId = wp.getVersionID();
					ProcessEditor processEditor = BPD.getInstance()
							.getActivedProcessEditor();
					// 将保存流程存入本地正在编辑的流程集合
					BPD.getInstance().getLocalEditingProcessMap().put(
							processDefVersionId, processEditor);
					// 将打开的本地流程路径存入本地流程路径集合
					BPD.getInstance().getXpdlFilePathMap().put(
							processDefVersionId, newFilename);

				}
				// 刷新流程列表
			
				MainLeftDownPanel.getInstance(this.editor).getPackageTreePanel().refreshPackageTreePanel();
				
				BPD.getInstance().getActivedProcessEditor().valueChanged(null);
				// pkgEditor.valueChanged(null);
				pkgEditor.invalidate();
			} catch (Exception ex) {
				ex.printStackTrace();
				BPD
						.getInstance()
						.message(
								ResourceManager
										.getLanguageDependentString("ErrorCannotSaveDocument"),
								JOptionPane.ERROR_MESSAGE);
			}
		}
	}

	// 验证流程的合法性
	private boolean validateWorkflowProcess() {
		PackageEditor pkgEditor = (PackageEditor) editor;
		// check graph
		boolean val = BPDConfig.getInstance().getValidationStatus();
		BPD.getInstance().getXMLInterface().setValidation(true);
		// 验证WorkflowProcess是否符合XPDLSchema
		boolean isXPDLSchemaValidationError = !BPD.getInstance()
				.getActivedProcessEditor().getGraph()
				.validateAgainsXPDLSchema();
		BPD.getInstance().getXMLInterface().setValidation(val);
		// 验证WorkflowProcess是否连接错误
		boolean isConnectionError = !BPD.getInstance()
				.getActivedProcessEditor().getGraph().checkConnections(true);
		boolean isGraphConformanceError = !BPD.getInstance()
				.getActivedProcessEditor().getGraph().checkGraphConformance(
						true);
		boolean isLogicError = !BPD.getInstance().getActivedProcessEditor()
				.getGraph().checkLogic(true);
		boolean isModelOK = !(isXPDLSchemaValidationError || isConnectionError
				|| isGraphConformanceError || isLogicError);
		if (!isModelOK) {
			// gets Hashtable with error messages
			Map xpdlSchemaValidationErrors = BPD.getInstance()
					.getActivedProcessEditor().getGraph()
					.getXPDLSchemaValidationErrorMessages();
			Map connectionErrors = BPD.getInstance().getActivedProcessEditor()
					.getGraph().getConnectionErrorMessages();
			java.util.List basicGraphConformanceErrors = BPD.getInstance()
					.getActivedProcessEditor().getGraph()
					.getBasicGraphConformanceErrorMessages();
			Map graphConformanceErrors = BPD.getInstance()
					.getActivedProcessEditor().getGraph()
					.getGraphConformanceErrorMessages();
			Map logicErrors = BPD.getInstance().getActivedProcessEditor()
					.getGraph().getLogicErrorMessages();

			// Prints connection error messages contained in a given Hashtable.
			// Hashtable has activity elements as a keys and it's error
			// connection messages as a values.
			String title = ResourceManager
					.getLanguageDependentString("DialogValidationReport");
			ValidationErrorDisplay ved = new ValidationErrorDisplay(
					xpdlSchemaValidationErrors, connectionErrors,
					basicGraphConformanceErrors, graphConformanceErrors,
					logicErrors, (JFrame) pkgEditor.getWindow(), title, true);
			if (ved.hasBeenStoped()) {
				return false;
			}
			// String
			// msg=ResourceManager.getLanguageDependentString("WarningIncorrectPackageSaving");
			// BPD.getInstance().message(msg,JOptionPane.WARNING_MESSAGE);
		}
		return true;
	}

	public static void updateExtendedAttributesForWorkflowProcesses(
			com.ds.bpm.bpd.xml.elements.Package pkg) {
		PackageEditor pkgEd = BPD.getInstance().getPackageEditor();
		// com.ds.bpm.bpd.xml.elements.Package pkg =
		// pkgEd.getRealXMLPackage();
		WorkflowProcess wp;
		com.ds.bpm.bpd.graph.Process pr;
		ProcessEditor pe;
		Iterator wps = ((WorkflowProcesses) pkg.get("WorkflowProcesses"))
				.toCollection().iterator();
		for (; wps.hasNext();) {
			// if (wps.hasNext()) {
			wp = (WorkflowProcess) wps.next();
			pr = pkgEd.getProcessObject(wp);
			if (pr != null) {
				pe = pr.getImplementationEditor();
				updateExtendedAttributesForWorkflowProcess(wp, pe);
			}
		}
	}

	public static void updateExtendedAttributesForWorkflowProcess(
			WorkflowProcess wp, ProcessEditor pe) {
		// 保存创建者和修改者信息
		wp.saveUserInfo();
		wp.setNew(false);
		
		updateActivitySets(pe);
		updateActivitiesExtendedAttributes(pe);
		updateTransitionsExtendedAttributes(pe);
		wp.setVisuallySortedParticipantIDs(getParticipantsVisualOrder(pe));
		wp.setStartDescriptions(Utils.getStartDescriptions(pe));
		wp.setEndDescriptions(Utils.getEndDescriptions(pe));
		// 更新流程中活动位置信息
		WorkflowManager.updateActivityPosition(wp);
	}

	private static void updateActivitySets(ProcessEditor pe) {
		if (pe != null) {
			WorkflowManager wm = pe.getGraph().getWorkflowManager();
			Set blockActs = wm.getBlockActivities(true);
			Iterator it = blockActs.iterator();
			while (it.hasNext()) {
				BlockActivity ba = (BlockActivity) it.next();
				ProcessEditor bwe = ba.getImplementationEditor();
				updateActivitiesExtendedAttributes(bwe);
				updateTransitionsExtendedAttributes(bwe);
				com.ds.bpm.bpd.xml.activity.Activity bap = (com.ds.bpm.bpd.xml.activity.Activity) ba
						.getUserObject();
				bap
						.setVisuallySortedParticipantIDs(getParticipantsVisualOrder(bwe));
				bap.setStartDescriptions(Utils.getStartDescriptions(bwe));
				bap.setEndDescriptions(Utils.getEndDescriptions(bwe));
			}
		}
	}

	private static void updateActivitiesExtendedAttributes(ProcessEditor pe) {
		if (pe != null) {
			WorkflowManager wm = pe.getGraph().getWorkflowManager();
			Set allActs = BPDGraphModel
					.getAllActivitiesInModel(wm.graphModel());
			if (allActs != null) {
				Iterator it = allActs.iterator();
				while (it.hasNext()) {
					Activity a = (Activity) it.next();
					// RECREATE OUTGOING TRANSITIONS OF ACTIVITY LOGIC TO SAVE
					// TRANSITION REFS CORRECTLY
					a.recreatePropertyObjectTransitions();
					if (!(a instanceof Start) && !(a instanceof End)) {
					    com.ds.bpm.bpd.xml.activity.Activity ap = (com.ds.bpm.bpd.xml.activity.Activity) a
								.getUserObject();
						// position
						
						if (pe.getGraph().getGraphLayoutCache().getMapping(a, false)!=null){
							Point pOffset = wm.getOffset(a);
							
							ap.setXOffset(pOffset.x);
							ap.setYOffset(pOffset.y);
							// participant that is holding activities graph object
							String Id = ((com.ds.bpm.bpd.xml.elements.Participant) ((Participant) a
									.getParent()).getUserObject()).getID();
							ap.setParticipantID(Id);
						};
						
					}
				}
			}
		}
	}

	private static void updateTransitionsExtendedAttributes(ProcessEditor pe) {
		if (pe != null) {
			WorkflowManager wm = pe.getGraph().getWorkflowManager();
			Set allTransitions = BPDGraphModel.getAllTransitionsInModel(wm
					.graphModel());
			if (allTransitions != null) {
				Iterator it = allTransitions.iterator();
				while (it.hasNext()) {
					Transition tr = (Transition) it.next();
					com.ds.bpm.bpd.xml.elements.Transition xmlT = (com.ds.bpm.bpd.xml.elements.Transition) tr
							.getUserObject();
					Activity s = tr.getSourceActivity();
					Activity t = tr.getTargetActivity();
					if (s.getUserObject() instanceof XMLElement
							&& t.getUserObject() instanceof XMLElement) {
						boolean isRouting = Utils.isRoutingTransition(tr
								.getAttributes());
						if (isRouting) {
							xmlT
									.setRoutingType(com.ds.bpm.bpd.xml.elements.Transition.SIMPLE_ROUTING);
						} else {
							xmlT
									.setRoutingType(com.ds.bpm.bpd.xml.elements.Transition.NO_ROUTING);
							TransitionView tv = (TransitionView) wm.getView(tr);
							int noOfPoints = tv.getPointCount();
							Hashtable pnts = new Hashtable();
							for (int j = 1; j < noOfPoints - 1; j++) {
								pnts.put(new Integer(j), tv.getPoint(j));
							}
							xmlT.setBreakPoints(pnts);
						}
					}
				}
			}
		}
	}

	private static String getParticipantsVisualOrder(ProcessEditor pe) {
		String visuallySortedParticipantIDs = "";
		if (pe != null) {
			WorkflowManager wm = pe.getGraph().getWorkflowManager();
			ParticipantComparator pc = new ParticipantComparator(wm);
			// gathering all visible participants in the WORKFLOW graph
			Set allDeps = BPDGraphModel.getAllParticipantsInModel(pe.getGraph()
					.getModel());
			if (allDeps != null) {
				ArrayList gparts = new ArrayList();
				gparts.addAll(allDeps);
				Collections.sort(gparts, pc);
				Iterator it = gparts.iterator();
				String participantID;
				while (it.hasNext()) {
					Participant participant=(Participant) it.next();
				if (participant!=null && participant.get("Id")!=null){
					participantID = participant.get("Id")
					.toString();
			visuallySortedParticipantIDs += (participantID + ";");
				}
					
				}
			}
		}
		return visuallySortedParticipantIDs;
	}

	private void updateExternalPackagesRelativePaths(
			com.ds.bpm.bpd.xml.elements.Package pkg, String newFilename) {
		File f = new File(newFilename);
		String parentF = f.getParent();
		Path newPath = new Path(parentF);
		Iterator eps = ((XMLCollection) pkg.get("ExternalPackages"))
				.toCollection().iterator();
		while (eps.hasNext()) {
			ExternalPackage ep = (ExternalPackage) eps.next();
			String oldRelativePath = ep.toString();
			try {
				com.ds.bpm.bpd.xml.elements.Package extP = BPD.getInstance().getXMLInterface()
						.getExternalPackageByRelativeFilePath(oldRelativePath,
								pkg);
				String oldFullPath = BPD.getInstance().getXMLInterface().getAbsoluteFilePath(extP);
				String relativePath = Path.getRelativePath(
						new Path(oldFullPath), newPath);
				// System.out.println("RP="+relativePath);
				ExternalPackage.AttrHref href = (ExternalPackage.AttrHref) ep
						.get("href");
				href.setPathDirectly(relativePath);
			} catch (Exception ex) {
				// ex.printStackTrace();
			}
		}
		// XML.printDebug();
	}

	/**
	 * Returns <code>true</code> if there are crosreferences.
	 */
	private boolean doesCrossreferenceExist(
			com.ds.bpm.bpd.xml.elements.Package pkg) {
		boolean crossRefs = false;
		Iterator eps = ((XMLCollection) pkg.get("ExternalPackages"))
				.toCollection().iterator();
		while (eps.hasNext()) {
			ExternalPackage ep = (ExternalPackage) eps.next();
			String relativePath = ep.toString();
			try {
				com.ds.bpm.bpd.xml.elements.Package extP = BPD.getInstance().getXMLInterface()
						.getExternalPackageByRelativeFilePath(relativePath, pkg);
				if (extP.getAllExternalPackages().contains(pkg)) {
					crossRefs = true;
					break;
				}
			} catch (Exception ex) {
			}
		}
		return crossRefs;
	}

	// ******************* PARTICIPANTCOMPARATOR CLASS **********************
	/**
	 * Used to properly sort visual objects that represents Participant's
	 * contained within graph.
	 */
	private static class ParticipantComparator implements Comparator {

		WorkflowManager workflowManager;

		public ParticipantComparator(WorkflowManager workflowManager) {
			this.workflowManager = workflowManager;
		}

		public int compare(Object o1, Object o2) {
			Participant p1 = (Participant) o1;
			Participant p2 = (Participant) o2;
			int y1 = workflowManager.getBounds(p1, null).getBounds().y;
			int y2 = workflowManager.getBounds(p2, null).getBounds().y;
			return (y1 < y2 ? -1 : (y1 == y2 ? 0 : 1));
		}
	}
	// **************** END OF PARTICIPANTCOMPARATOR CLASS ******************

}
