/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;

/**
 * Class that realizes <B>open</B> action.
 */
public class Reopen extends ActionBase {

   public Reopen (PackageEditor editor) {
      super(editor);
   }

   public void actionPerformed(ActionEvent e) {
      String name = BPD.getInstance().getFilename();
      if (name==null) {
         String msg=ResourceManager.getLanguageDependentString("WarningCannotReopenXPDL");
         BPD.getInstance().message(msg,JOptionPane.WARNING_MESSAGE);
         return;
      }
      if (BPD.getInstance().close()) {
         BPD.getInstance().checkNameAndOpenDocumentIfPossible(name);
      }
   }

}
