/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.JOptionPane;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.graph.Activity;
import com.ds.bpm.bpd.xml.elements.PackageHeader;

public class ReferredDocument extends ActionBase {

   public ReferredDocument(AbstractEditor editor) {
      super(editor);
   }

   public void actionPerformed(ActionEvent e) {
      if (!(editor instanceof PackageEditor)) {
         // First get the selected Activity, and it's referred document
         Activity selected = (Activity)editor.getGraph().getSelectionCell();
         String doc = selected.get("Documentation").toString();
         // Then check if the file can be read, and complain about it.
         showExternalDocument(doc);
      } else {
         String doc=((PackageHeader)((PackageEditor)editor).getXMLPackage().
            get("PackageHeader")).get("Documentation").toString();
         showExternalDocument(doc);
      }
   }

   /**
    * Java doesn't support direct opening of arbitrary documents,
    * but this hack should do it. For Windows executing "start", and
    * for KDE "kfmclient exec" will open document with associated
    * application. Associations are of course system dependant, and
    * we cannot do anything about them.
    */
   private void showExternalDocument(String document) {
      if (!(new File(document).canRead())) {
         JOptionPane.showMessageDialog(editor.getWindow(),
            document+": "+
            ResourceManager.getLanguageDependentString("InformationFileNotReadable"),
            BPD.getAppTitle(), JOptionPane.INFORMATION_MESSAGE);
         return;
      }
      String startCommand = System.getProperty("path.to.start");
      if (null != startCommand) {
         if(!new File(startCommand).canRead()) {
            JOptionPane.showMessageDialog(editor.getWindow(), startCommand + ": "
               +ResourceManager.getLanguageDependentString("InformationFileNotReadable"),
               BPD.getAppTitle(), JOptionPane.INFORMATION_MESSAGE);
            return;
         }
         if (System.getProperty("path.separator").equals(";")) {
            document = "\"" + document + "\"";
         }
      } else {
         if (System.getProperty("path.separator").equals(":")) {
            startCommand = "kfmclient exec";
         } else {
            startCommand = "cmd /c start";
            document = "\"" + document + "\"" + " \"" + document + "\"";
         }
      }
      try {
         Runtime.getRuntime().exec(startCommand + " " + document);
      } catch (Throwable t) {
         t.printStackTrace();
      }
   }


}
