/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：重复的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;
import java.util.Set;

import javax.swing.Action;
import javax.swing.undo.CannotRedoException;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDGraphModel;
import com.ds.bpm.bpd.ResourceManager;

/**
 * Class that realizes <B>redo</B> action
 */
public class Redo extends ActionBase {

	public Redo(AbstractEditor editor) {
		super(editor);
		setEnabled(false);
	}

	public void actionPerformed(ActionEvent e) {
		if (BPD.getInstance().getActivedProcessEditor() != null) {
			try {
				Set s1 = BPDGraphModel.getAllCellsInModel(BPD.getInstance()
						.getActivedProcessEditor().getGraph().getModel());
				BPD.getInstance().getActivedProcessEditor().getUndoManager()
						.redo(
								BPD.getInstance().getActivedProcessEditor()
										.getGraph().getGraphLayoutCache());
				Set s2 = BPDGraphModel.getAllCellsInModel(BPD.getInstance()
						.getActivedProcessEditor().getGraph().getModel());
				BPD.getInstance().getActivedProcessEditor().refreshCollections(
						s1, s2);
			} catch (CannotRedoException ex) {
				System.err.println("Unable to redo: " + ex);
				ex.printStackTrace();
			}
			update();
			editor.getUndo().update();
			BPD.getInstance().getActivedProcessEditor().getGraph().repaint();
			// graph.getUI().paint(editor.getGraph().getGraphics(),editor.getGraph());
		}
	}

	public void update() {
		if (BPD.getInstance().getActivedProcessEditor() != null) {
			if (BPD.getInstance().getActivedProcessEditor().getUndoManager()
					.canRedo(
							BPD.getInstance().getActivedProcessEditor()
									.getGraph().getGraphLayoutCache())) {
				setEnabled(true);
				putValue(Action.NAME, BPD.getInstance()
						.getActivedProcessEditor().getUndoManager()
						.getRedoPresentationName());
				editor.getToolbarComponent("Redo").setToolTipText(
						BPD.getInstance().getActivedProcessEditor()
								.getUndoManager().getRedoPresentationName());
			} else {
				setEnabled(false);
				putValue(Action.NAME, ResourceManager
						.getLanguageDependentString("RedoLabel"));
			}
		}
	}
}
