/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：编辑工作流相关属性的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JFrame;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Class that realizes <B>workflow relevat data</B> action.
 */
public class ProcessRelevantProperties extends ActionBase {

	public ProcessRelevantProperties(AbstractEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		XMLPanel p;
		XMLElementDialog d;

		if (BPD.getInstance().getActivedProcessEditor() != null) {
			com.ds.bpm.bpd.xml.elements.WorkflowProcess wp = (com.ds.bpm.bpd.xml.elements.WorkflowProcess) BPD
					.getInstance().getActivedProcessEditor().getGraph()
					.getPropertyObject();
			p = wp.getPanel(6);
			d = new XMLElementDialog(
					(JFrame) editor.getWindow(),
					ResourceManager.getLanguageDependentString("ProcessKey")
							+ " '"
							+ wp.toString()
							+ "' - "
							+ ResourceManager
									.getLanguageDependentString("DataFieldsKey"));
		} else {
			PackageEditor pe = (PackageEditor) editor;
			if (!pe.isInitialized()) {
				pe.enterPackageID();
			}
			p = pe.getXMLPackage().getPanel(8);
			d = new XMLElementDialog((JFrame) pe.getWindow(), ResourceManager
					.getLanguageDependentString("PackageKey")
					+ " '"
					+ pe.getXMLPackage().get("Id").toString()
					+ "' - "
					+ ResourceManager
							.getLanguageDependentString("DataFieldsKey"));
		}
		d.editXMLElement(p, false, false);
	}
}
