/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JFrame;

import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;


/**
 * Class that realizes <B>package properties</B> action.
 */
public class PackageProperties extends ActionBase {

   public PackageProperties (PackageEditor editor) {
      super(editor);
   }

   public void actionPerformed(ActionEvent e) {
      PackageEditor pe=(PackageEditor)editor;
      if (!pe.isInitialized()) {
         pe.enterPackageID();
      }
      XMLPanel p1=pe.getXMLPackage().getPanel(1);
      XMLPanel p2=pe.getXMLPackage().getPanel(2);
      XMLPanel p3=pe.getXMLPackage().getPanel(3);
      XMLTabbedPanel p=new XMLTabbedPanel(pe.getXMLPackage(),
         new XMLPanel[] {p1,p2,p3});

      XMLElementDialog d=new XMLElementDialog((JFrame)pe.getWindow(),
         ResourceManager.getLanguageDependentString("PackageKey")+" '"+
         pe.getXMLPackage().get("Id").toString()+"' - "+
         ResourceManager.getLanguageDependentString("PropertiesKey"));
      d.editXMLElement(p,true,false);
      pe.update();
   }
}
