/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：打开远程服务器工作流的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.server.panels.OpenRemoteDialog;

/**
 * Class that realizes <B>OpenRemote</B> action.
 */
public class OpenRemote extends ActionBase {

    /**
     * 打开远端服务器流程操作的构造方法
     * 
     * @param editor
     *            主界面对象
     */
    public OpenRemote(PackageEditor editor) {
	super(editor);
    }

    /**
     * 操作的具体实现方法
     * 
     * @param e
     *            操作事件
     */
    public void actionPerformed(ActionEvent e) {
	if (BPD.getInstance().isLogined()) {
	    // 如果用户已经登陆，则显示工作流列表对话框
	    Dimension dialogDimension = new Dimension(300, 200);
	    JFrame frame = (JFrame) editor.getWindow();
	    String title = ResourceManager.getLanguageDependentString("RemoteProcessList.Name.display");

	    final OpenRemoteDialog openRemoteDlg = new OpenRemoteDialog(frame, title, true);
	    openRemoteDlg.setSize(dialogDimension);
	    openRemoteDlg.setLocationRelativeTo(frame);
	    Utils.center(openRemoteDlg, 100, 100);
	    openRemoteDlg.show();

	} else {
	    // 没有登陆，显示警告对话框
	    JOptionPane.showMessageDialog(editor.getWindow(), ResourceManager.getLanguageDependentString("WarningUserIsNotLogined"), BPD.getAppTitle(), JOptionPane.WARNING_MESSAGE);
	}
    }
}
