/**New.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：新建工作流的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;

import javax.swing.JFrame;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDMarqueeHandler;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ProcessGraph;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.WorkflowManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.elements.WFApplication;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.config.PluginType;

/**
 * Class that realizes <B>new</B> action. 新建流程操作
 */
public class New extends ActionBase {

	
	private String systemCode;
	private String classification;
	public New(PackageEditor editor) {
		super(editor);
	}
	public New(PackageEditor editor,String systemCode,String classification) {
		super(editor);
		this.systemCode=systemCode;
		this.classification=classification;
	}
	public void actionPerformed(ActionEvent e) {
		// if (BPD.getInstance().close()) {
		createNewProcess();
		PackageEditor pe = (PackageEditor) editor;
		/*
		 * if (!pe.isInitialized()) { pe.enterPackageID(); }
		 */
		if (BPD.getInstance().getActivedProcessEditor() != null) {
			pe.update();
		
		}

		// }
	}

	public static void openNewPackage() {
		PackageEditor pe = BPD.getInstance().getPackageEditor();
		/*
		 * if (BPD.getInstance().getRealXMLPackage()!=null) {
		 * pe.displayPackage(BPD.getInstance().getRealXMLPackage()); }
		 */
		com.ds.bpm.bpd.xml.elements.Package pkg = BPD.getInstance()
				.openDocument(null, true, false);
		pe.setNewPackage(pkg, true);
	}
	
	
	

	/**
	 * 创建一个新的工作流界面
	 */
	public void createNewProcess() {
		PackageEditor pkgEditor = (PackageEditor) editor;
		// 选择工作流所属应用
		WFApplication wfApp = new WFApplication(this.systemCode,this.classification);
		//if (this.systemCode==null ||this.flowType==null){
			XMLPanel p = wfApp.getPanel();
			XMLElementDialog ed = new XMLElementDialog((JFrame) pkgEditor
					.getWindow(), ResourceManager
					.getLanguageDependentString("Process.Application.title"));
			ed.editXMLElement(p, true, false);
			
		
			if (ed.isCanceled()) {
				return;
			} 
	//	}
		classification=wfApp.get(PluginType.Classification.getType()).toValue().toString();
		 systemCode = wfApp.get("SystemCode").toValue().toString();
		
//		if (!systemCode.equals("")) {
//			// 把应用配置文件下载到本地
//			AppConfigManager.getInstance().downloadConfigFile(systemCode);
//		}
		com.ds.bpm.bpd.xml.elements.Package pkg = BPD.getInstance()
				.openDocument(null, true, false);
		pkgEditor.setNewPackage(pkg, true);

		// 创建新的工作流
		com.ds.bpm.bpd.graph.Process pr = (new WorkflowManager(null,
				pkgEditor)).insertProcess(null, true, wfApp);
		
		WorkflowProcess wp = (WorkflowProcess) pr.getUserObject();
		
		wp.setNew(true);
		
		if (pkgEditor.createWorkflowProcess(wp)) {

			if (pkgEditor.getContentTabbedPane().getTabCount() == 0) {
				pkgEditor.resetUndoManager();
			}

			// 创建新的工作流之前，设置当前激活工作流为null
			BPD.getInstance().setActivedProcessEditor(null);
			pkgEditor.putProcessObjectMapping(wp, pr);
			pr.showProcess();

			// 当前工作流的图形界面与图形按钮进行绑定
			ProcessGraph processGraph = (ProcessGraph) pr
					.getImplementationEditor().getGraph();
			processGraph.setMarqueeHandler(new BPDMarqueeHandler(processGraph));
			// 修改主界面状态栏信息
			pkgEditor.getStatusBar().updateMessage();
			//JPanel jpanel=BPD.getInstance().getErrTablePanel().getTablePanel();
			//editor.errPanel=jpanel;
			//editor.graphMainsplitPane.setBottomComponent(jpanel);
			// 把插入缺省Participant的操作不记入UndoManager
			processGraph.getEditor().getUndoHandler().setAddEdits(false);
			// 创建缺省的画图背景
			processGraph
					.getWorkflowManager()
					.insertParticipantAndArrangeParticipants(
							new Point(processGraph.getX(), processGraph.getY()),
							null);
			processGraph.getEditor().getUndoHandler().setAddEdits(true);
			processGraph.clearSelection();

			BPD.getInstance().getActivedProcessEditor().setProcessModified(
					false);

			// 创建工作流后，设置工作流配置的按钮是否可用
			BPD.getInstance().getActivedProcessEditor().valueChanged(null);

			// 刷新流程列表
			// ((PackageEditor)
			// editor).getPackageTreePanel().refreshPackageTreePanel();

		}
	}
}
