/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JFrame;

import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Class that realizes <B>Namespaces</B> action.
 */
public class Namespaces extends ActionBase {

	public Namespaces(PackageEditor pe) {
		super(pe);
	}

	public void actionPerformed(ActionEvent e) {
		PackageEditor pe = (PackageEditor) editor;
		if (!pe.isInitialized()) {
			pe.enterPackageID();
		}
		com.ds.bpm.bpd.xml.elements.Package pkg = pe.getXMLPackage();
		XMLPanel p = pkg.getPanel(11);
		XMLElementDialog d = new XMLElementDialog((JFrame) editor.getWindow(),
				ResourceManager.getLanguageDependentString("PackageKey")
						+ " '"
						+ pkg.toString()
						+ "' - "
						+ ResourceManager
								.getLanguageDependentString("NamespacesKey"));
		d.editXMLElement(p, false, false);
	}
}
