/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：注销的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.MainLeftDownPanel;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;

/**
 * Class that realizes <B>Login</B> action.
 */
public class Logout extends ActionBase {

	/**
	 * 注销操作的构造方法
	 * 
	 * @param editor
	 *            主界面对象
	 */
	public Logout(PackageEditor editor) {
		super(editor);
	}

	/**
	 * 操作的具体实现方法
	 * 
	 * @param e
	 *            操作事件
	 */
	public void actionPerformed(ActionEvent e) {
		// 注销操作
		int flag = JOptionPane.showConfirmDialog(editor.getWindow(),
				ResourceManager
						.getLanguageDependentString("MessageUserIsLogouted"),
				BPD.getAppTitle(), JOptionPane.YES_NO_OPTION);
		
		if (flag == JOptionPane.YES_OPTION) {
			// 注销后关闭当前用户打开的所有远端流程
			if (BPD.getInstance().getActivedProcessEditor() != null) {
				JTabbedPane ctp = ((PackageEditor) editor)
						.getContentTabbedPane();
				Component[] processEditorArray = (Component[]) ctp
						.getComponents();
				for (int i = 0; i < processEditorArray.length; i++) {
					ProcessEditor processEditor = ((ProcessEditor) processEditorArray[i]);
					if (processEditor.getProcessFlag() != null
							&& processEditor.getProcessFlag().equals(
									BPDConstants.PROCESS_REMOTE)) {
						ctp.setSelectedComponent(processEditor);
						((PackageEditor) editor).getAction("Close")
								.actionPerformed(e);
					}
				}
				BPD.getInstance().getRemoteEditingProcessMap().clear();
				// 清空所有打开的远程流程集合
				BPD.getInstance().getRemoteEditingProcessMap().clear();
				// 设置登录标志为未登录
				BPD.getInstance().setLoginFlag(false);
				// 设置当前登录用户未空
				BPD.getInstance().setUserInfo(null);
				// 指定所有打开流程的登录编辑用户
				BPD.getInstance().setLoginedUserForOpenedProcesses();
				// 清空远程流程集合
				BPD.getInstance().getRemoteProcessMap().clear();
				// 刷新流程树列表
				MainLeftDownPanel.getInstance(editor).getPackageTreePanel()
						.refreshPackageTreePanel();
				MainLeftDownPanel.getInstance(editor).getRemotePackageTreePanel()
				.refreshPackageTreePanel();
				editor.valueChanged(null);
				editor.getAction(Utils.getUnqualifiedClassName(Login.class))
						.actionPerformed(e);
			}
		
		}
	}
}
