/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JFrame;

import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.PackageGraph;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.misc.ExternalProcesses;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLElementDialog;

/**
 * Class that realizes <B>import external process</B> action.
 */
public class ImportExternalProcess extends ActionBase {

   public ImportExternalProcess (PackageEditor editor) {
      super(editor);
   }

   public void actionPerformed(ActionEvent e) {
      PackageEditor pe=(PackageEditor)editor;
      if (!pe.isInitialized()) {
         pe.enterPackageID();
      }

      ExternalProcesses ews=new ExternalProcesses(pe.getXMLPackage());

      XMLElementDialog d=new XMLElementDialog((JFrame)pe.getWindow(),
         ResourceManager.getLanguageDependentString("PackageKey")+" '"+
         pe.getXMLPackage().get("Id").toString()+"' - "+
         ResourceManager.getLanguageDependentString("ImportExternalProcessLabel"));
      d.editXMLElement(ews.getPanel(),true,false);
      if (!d.isCanceled()) {
         com.ds.bpm.bpd.xml.elements.WorkflowProcess wp=
            (com.ds.bpm.bpd.xml.elements.WorkflowProcess)
            ((XMLComplexChoice)ews.get("Process")).getChoosen();
         if (wp!=null) {
            com.ds.bpm.bpd.xml.elements.WorkflowProcesses wps=
               (com.ds.bpm.bpd.xml.elements.WorkflowProcesses)
               pe.getXMLPackage().get("WorkflowProcesses");
            com.ds.bpm.bpd.xml.elements.WorkflowProcess wpCopy=
               wps.createCopyOfWorkflowProcess(wp,false);

            // if something went wrong
            if (wpCopy==null) return;

            ((PackageGraph)pe.getGraph()).createWorkflowObject(pe.getWindow(),wpCopy);
            wps.decrementID();
            editor.requestFocus();
         }
      }
   }
}
