/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JDialog;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Class that realizes <B>formal parameters</B> action.
 */
public class FormalParameters extends ActionBase {

	public FormalParameters(PackageEditor pe) {
		super(pe);
	}

	public void actionPerformed(ActionEvent e) {
		com.ds.bpm.bpd.xml.elements.WorkflowProcess wp = (com.ds.bpm.bpd.xml.elements.WorkflowProcess) BPD
				.getInstance().getActivedProcessEditor().getGraph()
				.getPropertyObject();
		XMLPanel p = wp.getPanel(7);
		XMLElementDialog d = new XMLElementDialog(
				(JDialog) editor.getWindow(),
				ResourceManager.getLanguageDependentString("ProcessKey")
						+ " '"
						+ wp.toString()
						+ "' - "
						+ ResourceManager
								.getLanguageDependentString("FormalParametersKey"));
		d.editXMLElement(p, false, false);
	}
}
