/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;

public class FocusNearestCell extends ActionBase {
	public static final int FOCUS_UP = 0;

	public static final int FOCUS_DOWN = 1;

	public static final int FOCUS_LEFT = 2;

	public static final int FOCUS_RIGHT = 3;

	private int direction = 0;

	public FocusNearestCell(AbstractEditor editor, int direction) {
		super(editor);
		this.direction = direction;
	}

	public void actionPerformed(ActionEvent e) {
		// gets the first selected cell
		Object cell = BPD.getInstance().getActivedProcessEditor().getGraph()
				.getSelectionCell();
		Object nearestCell = BPD.getInstance().getActivedProcessEditor()
				.getGraph().getWorkflowManager().findNearestCell(cell,
						direction);
		if (nearestCell != null) {
			BPD.getInstance().getActivedProcessEditor().getGraph()
					.setSelectionCell(nearestCell);
		}
	}
}
